/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.client.MongoDriverInformation;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    private static final String DRIVER_NAME = "mongo-java-driver-reactivestreams";
    private static final String DRIVER_VERSION = MongoClients.getDriverVersion();
    private static final MongoDriverInformation DEFAULT_DRIVER_INFORMATION = MongoDriverInformation.builder().driverName("mongo-java-driver-reactivestreams").driverVersion(DRIVER_VERSION).build();

    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(com.mongodb.async.client.MongoClients.create((ConnectionString)connectionString, (MongoDriverInformation)MongoClients.getMongoDriverInformation(mongoDriverInformation)));
    }

    public static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(com.mongodb.async.client.MongoClients.create((MongoClientSettings)settings, (MongoDriverInformation)MongoClients.getMongoDriverInformation(mongoDriverInformation)));
    }

    public static MongoClient create(com.mongodb.async.client.MongoClient asyncMongoClient) {
        return new MongoClientImpl(asyncMongoClient);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return com.mongodb.async.client.MongoClients.getDefaultCodecRegistry();
    }

    private static MongoDriverInformation getMongoDriverInformation(MongoDriverInformation mongoDriverInformation) {
        if (mongoDriverInformation == null) {
            return DEFAULT_DRIVER_INFORMATION;
        }
        return MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation).driverName(DRIVER_NAME).driverVersion(DRIVER_VERSION).build();
    }

    private static String getDriverVersion() {
        String driverVersion = "unknown";
        try {
            CodeSource codeSource = MongoClients.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                JarURLConnection jarURLConnection;
                Manifest manifest;
                String version;
                URL jarUrl;
                String path = codeSource.getLocation().getPath();
                URL uRL = jarUrl = path.endsWith(".jar") ? new URL("jar:file:" + path + "!/") : null;
                if (jarUrl != null && (version = (String)(manifest = (jarURLConnection = (JarURLConnection)jarUrl.openConnection()).getManifest()).getMainAttributes().get(new Attributes.Name("Build-Version"))) != null) {
                    driverVersion = version;
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return driverVersion;
    }

    private MongoClients() {
    }
}

