/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.async.client.Observable;
import com.mongodb.async.client.Observer;
import com.mongodb.async.client.Subscription;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class ObservableToPublisher<TResult>
implements Publisher<TResult> {
    private final Observable<TResult> observable;

    public ObservableToPublisher(Observable<TResult> observable) {
        this.observable = observable;
    }

    public void subscribe(final Subscriber<? super TResult> subscriber) {
        this.observable.subscribe(new Observer<TResult>(){

            public void onSubscribe(final Subscription subscription) {
                subscriber.onSubscribe(new org.reactivestreams.Subscription(){
                    private final AtomicBoolean cancelled = new AtomicBoolean();

                    public void request(long n) {
                        if (!subscription.isUnsubscribed() && n < 1L) {
                            subscriber.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                        } else {
                            try {
                                subscription.request(n);
                            }
                            catch (Throwable t) {
                                subscriber.onError(t);
                            }
                        }
                    }

                    public void cancel() {
                        if (!this.cancelled.getAndSet(true)) {
                            subscription.unsubscribe();
                        }
                    }
                });
            }

            public void onNext(TResult result) {
                subscriber.onNext(result);
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }
}

