/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.ObservableToPublisher;
import com.mongodb.reactivestreams.client.PublisherHelper;
import com.mongodb.reactivestreams.client.Success;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class MapReducePublisherImpl<TResult>
implements MapReducePublisher<TResult> {
    private final MapReduceIterable<TResult> wrapped;

    MapReducePublisherImpl(MapReduceIterable<TResult> wrapped) {
        this.wrapped = (MapReduceIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public MapReducePublisher<TResult> collectionName(String collectionName) {
        this.wrapped.collectionName(collectionName);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> finalizeFunction(String finalizeFunction) {
        this.wrapped.finalizeFunction(finalizeFunction);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> scope(Bson scope) {
        this.wrapped.scope(scope);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> sort(Bson sort) {
        this.wrapped.sort(sort);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> limit(int limit) {
        this.wrapped.limit(limit);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> jsMode(boolean jsMode) {
        this.wrapped.jsMode(jsMode);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> verbose(boolean verbose) {
        this.wrapped.verbose(verbose);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> action(MapReduceAction action) {
        this.wrapped.action(action);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> databaseName(String databaseName) {
        this.wrapped.databaseName(databaseName);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> sharded(boolean sharded) {
        this.wrapped.sharded(sharded);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> nonAtomic(boolean nonAtomic) {
        this.wrapped.nonAtomic(nonAtomic);
        return this;
    }

    @Override
    public MapReducePublisher<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.wrapped.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    @Override
    public Publisher<Success> toCollection() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MapReducePublisherImpl.this.wrapped.toCollection(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public MapReducePublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public void subscribe(Subscriber<? super TResult> s) {
        new ObservableToPublisher<TResult>(Observables.observe(this.wrapped)).subscribe(s);
    }
}

