/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.Success;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoDatabase withReadConcern(ReadConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public Publisher<Document> runCommand(Bson var1);

    public Publisher<Document> runCommand(Bson var1, ReadPreference var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, Class<TResult> var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, ReadPreference var2, Class<TResult> var3);

    public Publisher<Success> drop();

    public Publisher<String> listCollectionNames();

    public ListCollectionsPublisher<Document> listCollections();

    public <TResult> ListCollectionsPublisher<TResult> listCollections(Class<TResult> var1);

    public Publisher<Success> createCollection(String var1);

    public Publisher<Success> createCollection(String var1, CreateCollectionOptions var2);
}

