/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadStream;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;

final class GridFSDownloadStreamImpl
implements GridFSDownloadStream {
    private final com.mongodb.async.client.gridfs.GridFSDownloadStream wrapped;

    GridFSDownloadStreamImpl(com.mongodb.async.client.gridfs.GridFSDownloadStream wrapped) {
        this.wrapped = (com.mongodb.async.client.gridfs.GridFSDownloadStream)Assertions.notNull((String)"GridFSDownloadStream", (Object)wrapped);
    }

    @Override
    public Publisher<GridFSFile> getGridFSFile() {
        return new ObservableToPublisher<GridFSFile>(Observables.observe((Block)new Block<SingleResultCallback<GridFSFile>>(){

            public void apply(SingleResultCallback<GridFSFile> callback) {
                GridFSDownloadStreamImpl.this.wrapped.getGridFSFile(callback);
            }
        }));
    }

    @Override
    public GridFSDownloadStream batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<Integer> read(final ByteBuffer dst) {
        return new ObservableToPublisher<Integer>(Observables.observe((Block)new Block<SingleResultCallback<Integer>>(){

            public void apply(SingleResultCallback<Integer> callback) {
                GridFSDownloadStreamImpl.this.wrapped.read(dst, callback);
            }
        }));
    }

    @Override
    public Publisher<Long> skip(final long bytesToSkip) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSDownloadStreamImpl.this.wrapped.skip(bytesToSkip, callback);
            }
        }));
    }

    @Override
    public Publisher<Success> close() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSDownloadStreamImpl.this.wrapped.close(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }
}

