/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.AggregateToCollectionThenFindOperation;
import com.mongodb.async.client.MongoIterableImpl;
import com.mongodb.client.model.Collation;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.session.ClientSession;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AggregateIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements AggregateIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final WriteConcern writeConcern;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean useCursor;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private Bson hint;

    AggregateIterableImpl(ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, AsyncOperationExecutor executor, List<? extends Bson> pipeline) {
        super(clientSession, executor, readConcern, readPreference);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
    }

    @Override
    public void toCollection(SingleResultCallback<Void> callback) {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        if (this.getOutCollection(aggregateList) == null) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out");
        }
        this.getExecutor().execute((AsyncWriteOperation)this.createAggregateToCollectionOperation(aggregateList), this.getClientSession(), callback);
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    @Deprecated
    public AggregateIterable<TResult> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hint(Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue outCollection = this.getOutCollection(aggregateList);
        if (outCollection != null) {
            AggregateToCollectionOperation aggregateToCollectionOperation = this.createAggregateToCollectionOperation(aggregateList);
            FindOperation findOperation = new FindOperation(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), (Decoder)this.codecRegistry.get(this.resultClass)).readConcern(this.getReadConcern()).collation(this.collation).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
            if (this.getBatchSize() != null) {
                findOperation.batchSize(this.getBatchSize().intValue());
            }
            return new AggregateToCollectionThenFindOperation((AsyncWriteOperation<Void>)aggregateToCollectionOperation, findOperation);
        }
        return new AggregateOperation(this.namespace, aggregateList, (Decoder)this.codecRegistry.get(this.resultClass)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).batchSize(this.getBatchSize()).useCursor(this.useCursor).readConcern(this.getReadConcern()).collation(this.collation).hint(this.hint == null ? null : this.hint.toBsonDocument(this.documentClass, this.codecRegistry)).comment(this.comment);
    }

    private BsonValue getOutCollection(List<BsonDocument> aggregateList) {
        return aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get((Object)"$out");
    }

    private AggregateToCollectionOperation createAggregateToCollectionOperation(List<BsonDocument> aggregateList) {
        return new AggregateToCollectionOperation(this.namespace, aggregateList, this.writeConcern).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation).hint(this.hint == null ? null : this.hint.toBsonDocument(this.documentClass, this.codecRegistry)).comment(this.comment);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(this.documentClass, this.codecRegistry));
        }
        return aggregateList;
    }
}

