/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.CursorType;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoIterableImpl;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.session.ClientSession;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class FindIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements FindIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final FindOptions findOptions;
    private Bson filter;

    FindIterableImpl(ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, AsyncOperationExecutor executor, Bson filter, FindOptions findOptions) {
        super(clientSession, executor, readConcern, readPreference);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.filter = (Bson)Assertions.notNull((String)"filter", (Object)filter);
        this.findOptions = (FindOptions)Assertions.notNull((String)"findOptions", (Object)findOptions);
    }

    @Override
    public FindIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public FindIterable<TResult> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindIterable<TResult> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> batchSize(int batchSize) {
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindIterable<TResult> collation(Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public FindIterable<TResult> modifiers(Bson modifiers) {
        this.findOptions.modifiers(modifiers);
        return this;
    }

    @Override
    public FindIterable<TResult> projection(Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindIterable<TResult> sort(Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public FindIterable<TResult> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindIterable<TResult> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public FindIterable<TResult> comment(String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindIterable<TResult> hint(Bson hint) {
        this.findOptions.hint(hint);
        return this;
    }

    @Override
    public FindIterable<TResult> max(Bson max) {
        this.findOptions.max(max);
        return this;
    }

    @Override
    public FindIterable<TResult> min(Bson min) {
        this.findOptions.min(min);
        return this;
    }

    @Override
    public FindIterable<TResult> maxScan(long maxScan) {
        this.findOptions.maxScan(maxScan);
        return this;
    }

    @Override
    public FindIterable<TResult> returnKey(boolean returnKey) {
        this.findOptions.returnKey(returnKey);
        return this;
    }

    @Override
    public FindIterable<TResult> showRecordId(boolean showRecordId) {
        this.findOptions.showRecordId(showRecordId);
        return this;
    }

    @Override
    public FindIterable<TResult> snapshot(boolean snapshot) {
        this.findOptions.snapshot(snapshot);
        return this;
    }

    @Override
    public void first(final SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        FindOperation findFirstOperation = this.createFindOperation().batchSize(0).limit(-1);
        this.getExecutor().execute((AsyncReadOperation)findFirstOperation, this.getReadPreference(), this.getClientSession(), new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(final AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.next(new SingleResultCallback<List<TResult>>(){

                        public void onResult(List<TResult> result, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (result == null || result.isEmpty()) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(result.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        return this.createFindOperation();
    }

    private FindOperation<TResult> createFindOperation() {
        return new FindOperation(this.namespace, (Decoder)this.codecRegistry.get(this.resultClass)).filter(this.filter.toBsonDocument(this.documentClass, this.codecRegistry)).batchSize(this.findOptions.getBatchSize()).skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).maxAwaitTime(this.findOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.toBsonDocumentOrNull(this.findOptions.getModifiers(), this.documentClass, this.codecRegistry)).projection(this.toBsonDocumentOrNull(this.findOptions.getProjection(), this.documentClass, this.codecRegistry)).sort(this.toBsonDocumentOrNull(this.findOptions.getSort(), this.documentClass, this.codecRegistry)).cursorType(this.findOptions.getCursorType()).noCursorTimeout(this.findOptions.isNoCursorTimeout()).oplogReplay(this.findOptions.isOplogReplay()).partial(this.findOptions.isPartial()).slaveOk(this.getReadPreference().isSlaveOk()).readConcern(this.getReadConcern()).collation(this.findOptions.getCollation()).comment(this.findOptions.getComment()).hint(this.toBsonDocumentOrNull(this.findOptions.getHint(), this.documentClass, this.codecRegistry)).min(this.toBsonDocumentOrNull(this.findOptions.getMin(), this.documentClass, this.codecRegistry)).max(this.toBsonDocumentOrNull(this.findOptions.getMax(), this.documentClass, this.codecRegistry)).maxScan(this.findOptions.getMaxScan()).returnKey(this.findOptions.isReturnKey()).showRecordId(this.findOptions.isShowRecordId()).snapshot(this.findOptions.isSnapshot());
    }
}

