/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.gridfs.GridFSIndexCheck;
import com.mongodb.async.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.HexUtils;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.session.ClientSession;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

final class GridFSUploadStreamImpl
implements GridFSUploadStream {
    private static final Logger LOGGER = Loggers.getLogger((String)"client.gridfs");
    private final ClientSession clientSession;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;
    private final BsonValue fileId;
    private final String filename;
    private final int chunkSizeBytes;
    private final Document metadata;
    private final MessageDigest md5;
    private final GridFSIndexCheck indexCheck;
    private final Object closeAndWritingLock = new Object();
    private boolean checkedIndexes;
    private boolean writing;
    private boolean closed;
    private byte[] buffer;
    private long lengthInBytes;
    private int bufferOffset;
    private int chunkIndex;

    GridFSUploadStreamImpl(ClientSession clientSession, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, BsonValue fileId, String filename, int chunkSizeBytes, Document metadata, GridFSIndexCheck indexCheck) {
        this.clientSession = clientSession;
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"files collection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunks collection", chunksCollection);
        this.fileId = (BsonValue)Assertions.notNull((String)"File Id", (Object)fileId);
        this.filename = (String)Assertions.notNull((String)"filename", (Object)filename);
        this.chunkSizeBytes = chunkSizeBytes;
        this.metadata = metadata;
        this.indexCheck = indexCheck;
        this.md5 = GridFSUploadStreamImpl.getDigest();
        this.chunkIndex = 0;
        this.bufferOffset = 0;
        this.buffer = new byte[chunkSizeBytes];
    }

    @Override
    public ObjectId getObjectId() {
        if (!this.fileId.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS upload stream");
        }
        return this.fileId.asObjectId().getValue();
    }

    @Override
    public BsonValue getId() {
        return this.fileId;
    }

    @Override
    public void abort(SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        if (!this.takeWritingLock(errHandlingCallback)) {
            return;
        }
        SingleResultCallback<DeleteResult> deleteCallback = new SingleResultCallback<DeleteResult>(){

            public void onResult(DeleteResult result, Throwable t) {
                GridFSUploadStreamImpl.this.releaseWritingLock();
                errHandlingCallback.onResult(null, t);
            }
        };
        if (this.clientSession != null) {
            this.chunksCollection.deleteMany(this.clientSession, (Bson)new Document("files_id", (Object)this.fileId), deleteCallback);
        } else {
            this.chunksCollection.deleteMany((Bson)new Document("files_id", (Object)this.fileId), deleteCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(final ByteBuffer src, SingleResultCallback<Integer> callback) {
        Assertions.notNull((String)"src", (Object)src);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        boolean checkIndexes = false;
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            checkIndexes = !this.checkedIndexes;
        }
        if (checkIndexes) {
            if (!this.takeWritingLock(errHandlingCallback)) {
                return;
            }
            this.indexCheck.checkAndCreateIndex(new SingleResultCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResult(Void result, Throwable t) {
                    Object object = GridFSUploadStreamImpl.this.closeAndWritingLock;
                    synchronized (object) {
                        GridFSUploadStreamImpl.this.checkedIndexes = true;
                    }
                    GridFSUploadStreamImpl.this.releaseWritingLock();
                    if (t != null) {
                        errHandlingCallback.onResult(null, t);
                    } else {
                        GridFSUploadStreamImpl.this.write(src, (SingleResultCallback<Integer>)errHandlingCallback);
                    }
                }
            });
        } else {
            this.write(src.remaining() == 0 ? -1 : src.remaining(), src, (SingleResultCallback<Integer>)errHandlingCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        boolean alreadyClosed = false;
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            alreadyClosed = this.closed;
            this.closed = true;
        }
        if (alreadyClosed) {
            errHandlingCallback.onResult(null, null);
            return;
        }
        if (!this.getAndSetWritingLock()) {
            this.callbackIsWritingException(errHandlingCallback);
            return;
        }
        this.writeChunk(new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    GridFSUploadStreamImpl.this.releaseWritingLock();
                    errHandlingCallback.onResult(null, t);
                } else {
                    GridFSFile gridFSFile = new GridFSFile(GridFSUploadStreamImpl.this.fileId, GridFSUploadStreamImpl.this.filename, GridFSUploadStreamImpl.this.lengthInBytes, GridFSUploadStreamImpl.this.chunkSizeBytes, new Date(), HexUtils.toHex((byte[])GridFSUploadStreamImpl.this.md5.digest()), GridFSUploadStreamImpl.this.metadata);
                    SingleResultCallback<Void> insertCallback = new SingleResultCallback<Void>(){

                        public void onResult(Void result, Throwable t) {
                            GridFSUploadStreamImpl.access$902(GridFSUploadStreamImpl.this, null);
                            GridFSUploadStreamImpl.this.releaseWritingLock();
                            errHandlingCallback.onResult((Object)result, t);
                        }
                    };
                    if (GridFSUploadStreamImpl.this.clientSession != null) {
                        GridFSUploadStreamImpl.this.filesCollection.insertOne(GridFSUploadStreamImpl.this.clientSession, gridFSFile, insertCallback);
                    } else {
                        GridFSUploadStreamImpl.this.filesCollection.insertOne(gridFSFile, insertCallback);
                    }
                }
            }
        });
    }

    private void write(final int amount, final ByteBuffer src, final SingleResultCallback<Integer> callback) {
        if (!this.takeWritingLock(callback)) {
            return;
        }
        int len = src.remaining();
        if (len == 0) {
            this.releaseWritingLock();
            callback.onResult((Object)amount, null);
            return;
        }
        int amountToCopy = len;
        if (amountToCopy > this.chunkSizeBytes - this.bufferOffset) {
            amountToCopy = this.chunkSizeBytes - this.bufferOffset;
        }
        src.get(this.buffer, this.bufferOffset, amountToCopy);
        this.bufferOffset += amountToCopy;
        this.lengthInBytes += (long)amountToCopy;
        if (this.bufferOffset == this.chunkSizeBytes) {
            this.writeChunk(new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    GridFSUploadStreamImpl.this.releaseWritingLock();
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        GridFSUploadStreamImpl.this.write(amount, src, (SingleResultCallback<Integer>)callback);
                    }
                }
            });
        } else {
            this.releaseWritingLock();
            callback.onResult((Object)amount, null);
        }
    }

    private <T> boolean takeWritingLock(SingleResultCallback<T> errHandlingCallback) {
        if (this.checkClosed()) {
            this.callbackClosedException(errHandlingCallback);
            return false;
        }
        if (!this.getAndSetWritingLock()) {
            this.releaseWritingLock();
            this.callbackIsWritingException(errHandlingCallback);
            return false;
        }
        return true;
    }

    private void writeChunk(final SingleResultCallback<Void> callback) {
        if (this.md5 == null) {
            callback.onResult(null, (Throwable)new MongoGridFSException("No MD5 message digest available, cannot upload file"));
        } else if (this.bufferOffset > 0) {
            Document insertDocument = new Document("files_id", (Object)this.fileId).append("n", (Object)this.chunkIndex).append("data", (Object)this.getData());
            SingleResultCallback<Void> insertCallback = new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        GridFSUploadStreamImpl.this.md5.update(GridFSUploadStreamImpl.this.buffer);
                        GridFSUploadStreamImpl.this.chunkIndex++;
                        GridFSUploadStreamImpl.this.bufferOffset = 0;
                        callback.onResult(null, null);
                    }
                }
            };
            if (this.clientSession != null) {
                this.chunksCollection.insertOne(this.clientSession, insertDocument, insertCallback);
            } else {
                this.chunksCollection.insertOne(insertDocument, insertCallback);
            }
        } else {
            callback.onResult(null, null);
        }
    }

    private Binary getData() {
        if (this.bufferOffset < this.chunkSizeBytes) {
            byte[] sizedBuffer = new byte[this.bufferOffset];
            System.arraycopy(this.buffer, 0, sizedBuffer, 0, this.bufferOffset);
            this.buffer = sizedBuffer;
        }
        return new Binary(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkClosed() {
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getAndSetWritingLock() {
        boolean gotLock = false;
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            if (!this.writing) {
                this.writing = true;
                gotLock = true;
            }
        }
        return gotLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWritingLock() {
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            this.writing = false;
        }
    }

    private <T> void callbackClosedException(SingleResultCallback<T> callback) {
        callback.onResult(null, (Throwable)new MongoGridFSException("The AsyncOutputStream has been closed"));
    }

    private <T> void callbackIsWritingException(SingleResultCallback<T> callback) {
        callback.onResult(null, (Throwable)new MongoGridFSException("The AsyncOutputStream does not support concurrent writing."));
    }

    private static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    static /* synthetic */ byte[] access$902(GridFSUploadStreamImpl x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }
}

