/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.ChangeStreamOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class ChangeStreamIterableImpl<TResult>
implements ChangeStreamIterable<TResult> {
    private final MongoNamespace namespace;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private final List<? extends Bson> pipeline;
    private final Codec<ChangeStreamDocument<TResult>> codec;
    private Integer batchSize;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private BsonDocument resumeToken;
    private long maxAwaitTimeMS;
    private Collation collation;

    ChangeStreamIterableImpl(MongoNamespace namespace, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, AsyncOperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.codec = ChangeStreamDocument.createCodec((Class)((Class)Assertions.notNull((String)"resultClass", resultClass)), (CodecRegistry)codecRegistry);
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocument(FullDocument fullDocument) {
        this.fullDocument = (FullDocument)Assertions.notNull((String)"fullDocument", (Object)fullDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> resumeAfter(BsonDocument resumeToken) {
        this.resumeToken = (BsonDocument)Assertions.notNull((String)"resumeToken", (Object)resumeToken);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> batchSize(int batchSize) {
        this.batchSize = (Integer)Assertions.notNull((String)"batchSize", (Object)batchSize);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> collation(Collation collation) {
        this.collation = (Collation)Assertions.notNull((String)"collation", (Object)collation);
        return this;
    }

    @Override
    public <S> MongoIterable<S> withDocumentClass(Class<S> resultClass) {
        return this.execute(this.codecRegistry.get(resultClass));
    }

    @Override
    public void first(SingleResultCallback<ChangeStreamDocument<TResult>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute(this.codec).first(callback);
    }

    @Override
    public void forEach(Block<? super ChangeStreamDocument<TResult>> block, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.execute(this.codec).forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super ChangeStreamDocument<TResult>>> void into(A target, SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.execute(this.codec).into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<ChangeStreamDocument<TResult>, U> mapper) {
        return new MappingIterable<ChangeStreamDocument<TResult>, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<ChangeStreamDocument<TResult>>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute(this.codec).batchCursor(callback);
    }

    private <S> MongoIterable<S> execute(Codec<S> codec) {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        ChangeStreamOperation changeStreamOperation = new ChangeStreamOperation(this.namespace, this.fullDocument, aggregateList, codec).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).batchSize(this.batchSize).readConcern(this.readConcern).collation(this.collation);
        if (this.resumeToken != null) {
            changeStreamOperation.resumeAfter(this.resumeToken);
        }
        return new OperationIterable(changeStreamOperation, this.readPreference, this.executor);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return aggregateList;
    }
}

