/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSessionBinding;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.session.ClientSessionImpl;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.selector.ServerSelector;
import com.mongodb.session.ClientSession;
import com.mongodb.session.ServerSession;
import java.util.List;

class AsyncOperationExecutorImpl
implements AsyncOperationExecutor {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoClientImpl mongoClient;

    AsyncOperationExecutorImpl(MongoClientImpl mongoClient) {
        this.mongoClient = mongoClient;
    }

    public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, SingleResultCallback<T> callback) {
        this.execute(operation, readPreference, null, callback);
    }

    public <T> void execute(final AsyncReadOperation<T> operation, final ReadPreference readPreference, final ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.getClientSession(session, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    AsyncReadWriteBinding binding = AsyncOperationExecutorImpl.this.getReadWriteBinding(readPreference, clientSession, session == null && clientSession != null);
                    operation.executeAsync((AsyncReadBinding)binding, new SingleResultCallback<T>((AsyncReadBinding)binding){
                        final /* synthetic */ AsyncReadBinding val$binding;
                        {
                            this.val$binding = asyncReadBinding;
                        }

                        public void onResult(T result, Throwable t) {
                            try {
                                errHandlingCallback.onResult(result, t);
                            }
                            finally {
                                this.val$binding.release();
                            }
                        }
                    });
                }
            }
        });
    }

    public <T> void execute(AsyncWriteOperation<T> operation, SingleResultCallback<T> callback) {
        this.execute(operation, null, callback);
    }

    public <T> void execute(final AsyncWriteOperation<T> operation, final ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.getClientSession(session, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    AsyncReadWriteBinding binding = AsyncOperationExecutorImpl.this.getReadWriteBinding(ReadPreference.primary(), clientSession, session == null && clientSession != null);
                    operation.executeAsync((AsyncWriteBinding)binding, new SingleResultCallback<T>((AsyncWriteBinding)binding){
                        final /* synthetic */ AsyncWriteBinding val$binding;
                        {
                            this.val$binding = asyncWriteBinding;
                        }

                        public void onResult(T result, Throwable t) {
                            try {
                                errHandlingCallback.onResult(result, t);
                            }
                            finally {
                                this.val$binding.release();
                            }
                        }
                    });
                }
            }
        });
    }

    private void getClientSession(ClientSession clientSessionFromOperation, SingleResultCallback<ClientSession> callback) {
        if (clientSessionFromOperation != null) {
            Assertions.isTrue((String)"ClientSession from same MongoClient", (clientSessionFromOperation.getOriginator() == this.mongoClient ? 1 : 0) != 0);
            callback.onResult((Object)clientSessionFromOperation, null);
        } else {
            this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build(), callback);
        }
    }

    private AsyncReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ClientSession session, boolean ownsSession) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Object readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), readPreference);
        if (session != null) {
            readWriteBinding = new ClientSessionBinding(session, ownsSession, (AsyncReadWriteBinding)readWriteBinding);
        }
        return readWriteBinding;
    }

    private void createClientSession(final ClientSessionOptions options, final SingleResultCallback<ClientSession> callback) {
        if (this.mongoClient.getSettings().getCredentialList().size() > 1) {
            callback.onResult(null, null);
        } else {
            ClusterDescription clusterDescription = this.mongoClient.getCluster().getDescription();
            if (!this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty() && clusterDescription.getLogicalSessionTimeoutMinutes() != null) {
                this.getServerSessionCallback(options, callback).onResult((Object)this.mongoClient.getServerSessionPool().get(), null);
            } else {
                this.mongoClient.getCluster().selectServerAsync(new ServerSelector(){

                    public List<ServerDescription> select(ClusterDescription clusterDescription) {
                        return AsyncOperationExecutorImpl.this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription);
                    }
                }, (SingleResultCallback)new SingleResultCallback<Server>(){

                    public void onResult(Server server, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, null);
                        } else if (server.getDescription().getLogicalSessionTimeoutMinutes() == null) {
                            callback.onResult(null, null);
                        } else {
                            AsyncOperationExecutorImpl.this.getServerSessionCallback(options, (SingleResultCallback<ClientSession>)callback).onResult((Object)AsyncOperationExecutorImpl.this.mongoClient.getServerSessionPool().get(), null);
                        }
                    }
                });
            }
        }
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return clusterDescription.getAny();
        }
        return clusterDescription.getAnyPrimaryOrSecondary();
    }

    private SingleResultCallback<ServerSession> getServerSessionCallback(final ClientSessionOptions options, final SingleResultCallback<ClientSession> callback) {
        return new SingleResultCallback<ServerSession>(){

            public void onResult(ServerSession serverSession, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new ClientSessionImpl(AsyncOperationExecutorImpl.this.mongoClient.getServerSessionPool(), serverSession, (Object)System.identityHashCode(AsyncOperationExecutorImpl.this.mongoClient), options), null);
                }
            }
        };
    }
}

