/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs;

import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.gridfs.GridFSIndexCheck;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import org.bson.Document;
import org.bson.conversions.Bson;

final class GridFSIndexCheckImpl
implements GridFSIndexCheck {
    private static final Document PROJECTION = new Document("_id", (Object)1);
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;

    GridFSIndexCheckImpl(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"files collection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunks collection", chunksCollection);
    }

    @Override
    public void checkAndCreateIndex(final SingleResultCallback<Void> callback) {
        this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary()).find().projection((Bson)PROJECTION).first(new SingleResultCallback<Document>(){

            public void onResult(Document result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result == null) {
                    GridFSIndexCheckImpl.this.checkFilesIndex((SingleResultCallback<Void>)callback);
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    private <T> void hasIndex(MongoCollection<T> collection, final Document index, final SingleResultCallback<Boolean> callback) {
        collection.listIndexes().into(new ArrayList(), new SingleResultCallback<ArrayList<Document>>(){

            public void onResult(ArrayList<Document> indexes, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    boolean hasIndex = false;
                    for (Document indexDoc : indexes) {
                        if (!((Document)indexDoc.get((Object)"key", Document.class)).equals((Object)index)) continue;
                        hasIndex = true;
                        break;
                    }
                    callback.onResult((Object)hasIndex, null);
                }
            }
        });
    }

    private void checkFilesIndex(final SingleResultCallback<Void> callback) {
        final Document filesIndex = new Document("filename", (Object)1).append("uploadDate", (Object)1);
        this.hasIndex(this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex, new SingleResultCallback<Boolean>(){

            public void onResult(Boolean result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (!result.booleanValue()) {
                    GridFSIndexCheckImpl.this.filesCollection.createIndex((Bson)filesIndex, new SingleResultCallback<String>(){

                        public void onResult(String result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                GridFSIndexCheckImpl.this.checkChunksIndex((SingleResultCallback<Void>)callback);
                            }
                        }
                    });
                } else {
                    GridFSIndexCheckImpl.this.checkChunksIndex((SingleResultCallback<Void>)callback);
                }
            }
        });
    }

    private void checkChunksIndex(final SingleResultCallback<Void> callback) {
        final Document chunksIndex = new Document("files_id", (Object)1).append("n", (Object)1);
        this.hasIndex(this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex, new SingleResultCallback<Boolean>(){

            public void onResult(Boolean result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (!result.booleanValue()) {
                    GridFSIndexCheckImpl.this.chunksCollection.createIndex((Bson)chunksIndex, new IndexOptions().unique(true), new SingleResultCallback<String>(){

                        public void onResult(String result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult(null, null);
                            }
                        }
                    });
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }
}

