/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AwaitingWriteOperationIterable;
import com.mongodb.async.client.FindIterableImpl;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonJavaScript;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MapReduceIterableImpl<TDocument, TResult>
implements MapReduceIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private final String mapFunction;
    private final String reduceFunction;
    private final WriteConcern writeConcern;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private int batchSize;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    MapReduceIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, AsyncOperationExecutor executor, String mapFunction, String reduceFunction) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.mapFunction = (String)Assertions.notNull((String)"mapFunction", (Object)mapFunction);
        this.reduceFunction = (String)Assertions.notNull((String)"reduceFunction", (Object)reduceFunction);
    }

    @Override
    public MapReduceIterable<TResult> collectionName(String collectionName) {
        this.collectionName = (String)Assertions.notNull((String)"collectionName", (Object)collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> scope(Bson scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public void toCollection(final SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"callback", callback);
        if (this.inline) {
            throw new IllegalArgumentException("The options must specify a non-inline result");
        }
        this.executor.execute((AsyncWriteOperation)this.createMapReduceToCollectionOperation(), (SingleResultCallback)new SingleResultCallback<MapReduceStatistics>(){

            public void onResult(MapReduceStatistics result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void first(SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute().first(callback);
    }

    @Override
    public void forEach(Block<? super TResult> block, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super TResult>> void into(A target, SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute().batchCursor(callback);
    }

    MongoIterable<TResult> execute() {
        if (this.inline) {
            MapReduceWithInlineResultsOperation operation = new MapReduceWithInlineResultsOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), (Decoder)this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocument(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocument(this.scope)).sort(this.toBsonDocument(this.sort)).verbose(this.verbose).readConcern(this.readConcern).collation(this.collation);
            if (this.finalizeFunction != null) {
                operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
            }
            return new OperationIterable(operation, this.readPreference, this.executor);
        }
        MapReduceToCollectionOperation operation = this.createMapReduceToCollectionOperation();
        String dbName = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        MongoIterable delegated = new FindIterableImpl<TDocument, TResult>(new MongoNamespace(dbName, this.collectionName), this.documentClass, this.resultClass, this.codecRegistry, ReadPreference.primary(), this.readConcern, this.executor, (Bson)new BsonDocument(), new FindOptions().collation(this.collation)).batchSize(this.batchSize);
        return new AwaitingWriteOperationIterable(operation, this.executor, delegated);
    }

    private MapReduceToCollectionOperation createMapReduceToCollectionOperation() {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.collectionName, this.writeConcern).filter(this.toBsonDocument(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocument(this.scope)).sort(this.toBsonDocument(this.sort)).verbose(this.verbose).action(this.action.getValue()).nonAtomic(this.nonAtomic).sharded(this.sharded).databaseName(this.databaseName).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation);
        if (this.finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
        }
        return operation;
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(this.documentClass, this.codecRegistry);
    }
}

