/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.management.JMXConnectionPoolListener;
import java.util.Arrays;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new DocumentCodecProvider(), new BsonValueCodecProvider(), new GeoJsonCodecProvider()));

    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return new MongoClientImpl(settings, MongoClients.createCluster(settings, MongoClients.getStreamFactory(settings)));
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(MongoClientSettings.builder().clusterSettings(ClusterSettings.builder().applyConnectionString(connectionString).build()).connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(connectionString).build()).serverSettings(ServerSettings.builder().build()).credentialList(connectionString.getCredentialList()).sslSettings(SslSettings.builder().applyConnectionString(connectionString).build()).socketSettings(SocketSettings.builder().applyConnectionString(connectionString).build()).build());
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    private static Cluster createCluster(MongoClientSettings settings, StreamFactory streamFactory) {
        StreamFactory heartbeatStreamFactory = MongoClients.getHeartbeatStreamFactory(settings);
        return new DefaultClusterFactory().create(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), null, (ConnectionPoolListener)new JMXConnectionPoolListener(), null);
    }

    private static StreamFactory getHeartbeatStreamFactory(MongoClientSettings settings) {
        return settings.getStreamFactoryFactory().create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings) {
        return settings.getStreamFactoryFactory().create(settings.getSocketSettings(), settings.getSslSettings());
    }

    private MongoClients() {
    }
}

