/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;

class KeyManagementService {
    private final int defaultPort;
    private final TlsChannelStreamFactoryFactory tlsChannelStreamFactoryFactory;
    private final StreamFactory streamFactory;

    KeyManagementService(SSLContext sslContext, int defaultPort, int timeoutMillis) {
        this.defaultPort = defaultPort;
        this.tlsChannelStreamFactoryFactory = new TlsChannelStreamFactoryFactory();
        this.streamFactory = this.tlsChannelStreamFactoryFactory.create(SocketSettings.builder().connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build(), SslSettings.builder().enabled(true).context(sslContext).build());
    }

    public void close() {
        this.tlsChannelStreamFactoryFactory.close();
    }

    void decryptKey(MongoKeyDecryptor keyDecryptor, SingleResultCallback<Void> callback) {
        this.streamOpen(keyDecryptor, callback);
    }

    private void streamOpen(final MongoKeyDecryptor keyDecryptor, final SingleResultCallback<Void> callback) {
        ServerAddress serverAddress = keyDecryptor.getHostName().contains(":") ? new ServerAddress(keyDecryptor.getHostName()) : new ServerAddress(keyDecryptor.getHostName(), this.defaultPort);
        final Stream stream = this.streamFactory.create(serverAddress);
        stream.openAsync((AsyncCompletionHandler)new AsyncCompletionHandler<Void>(){

            public void completed(Void aVoid) {
                KeyManagementService.this.streamWrite(stream, keyDecryptor, (SingleResultCallback<Void>)callback);
            }

            public void failed(Throwable t) {
                stream.close();
                callback.onResult(null, KeyManagementService.this.wrapException(t));
            }
        });
    }

    private void streamWrite(final Stream stream, final MongoKeyDecryptor keyDecryptor, final SingleResultCallback<Void> callback) {
        List<ByteBufNIO> byteBufs = Collections.singletonList(new ByteBufNIO(keyDecryptor.getMessage()));
        stream.writeAsync(byteBufs, (AsyncCompletionHandler)new AsyncCompletionHandler<Void>(){

            public void completed(Void aVoid) {
                KeyManagementService.this.streamRead(stream, keyDecryptor, (SingleResultCallback<Void>)callback);
            }

            public void failed(Throwable t) {
                stream.close();
                callback.onResult(null, KeyManagementService.this.wrapException(t));
            }
        });
    }

    private void streamRead(final Stream stream, final MongoKeyDecryptor keyDecryptor, final SingleResultCallback<Void> callback) {
        int bytesNeeded = keyDecryptor.bytesNeeded();
        if (bytesNeeded > 0) {
            AsynchronousChannelStream asyncStream = (AsynchronousChannelStream)stream;
            final ByteBuf buffer = asyncStream.getBuffer(bytesNeeded);
            asyncStream.getChannel().read(buffer.asNIO(), (long)asyncStream.getSettings().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer integer, Void aVoid) {
                    buffer.flip();
                    try {
                        keyDecryptor.feed(buffer.asNIO());
                        buffer.release();
                        KeyManagementService.this.streamRead(stream, keyDecryptor, (SingleResultCallback<Void>)callback);
                    }
                    catch (Throwable t) {
                        callback.onResult(null, t);
                    }
                }

                @Override
                public void failed(Throwable t, Void aVoid) {
                    buffer.release();
                    stream.close();
                    callback.onResult(null, KeyManagementService.this.wrapException(t));
                }
            });
        } else {
            stream.close();
            callback.onResult(null, null);
        }
    }

    private Throwable wrapException(Throwable t) {
        return t instanceof MongoSocketException ? t.getCause() : t;
    }
}

