/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.vault;

import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.internal.Crypt;
import com.mongodb.async.client.internal.Crypts;
import com.mongodb.async.client.vault.ClientEncryption;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import java.io.Closeable;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

class ClientEncryptionImpl
implements ClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(this.keyVaultClient, options);
        this.options = options;
    }

    @Override
    public void createDataKey(String kmsProvider, SingleResultCallback<BsonBinary> callback) {
        this.createDataKey(kmsProvider, new DataKeyOptions(), callback);
    }

    @Override
    public void createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions, final SingleResultCallback<BsonBinary> callback) {
        this.crypt.createDataKey(kmsProvider, dataKeyOptions, new SingleResultCallback<RawBsonDocument>(){

            public void onResult(final RawBsonDocument dataKeyDocument, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    MongoNamespace namespace = new MongoNamespace(ClientEncryptionImpl.this.options.getKeyVaultNamespace());
                    ClientEncryptionImpl.this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne((BsonDocument)dataKeyDocument, new SingleResultCallback<Void>(){

                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult((Object)dataKeyDocument.getBinary((Object)"_id"), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void encrypt(BsonValue value, EncryptOptions options, SingleResultCallback<BsonBinary> callback) {
        this.crypt.encryptExplicitly(value, options, callback);
    }

    @Override
    public void decrypt(BsonBinary value, SingleResultCallback<BsonValue> callback) {
        this.crypt.decryptExplicitly(value, callback);
    }

    @Override
    public void close() {
        this.keyVaultClient.close();
        this.crypt.close();
    }
}

