/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClients;
import com.mongodb.internal.capi.MongoCryptHelper;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private final MongoClient client;
    private final ProcessBuilder processBuilder;

    CommandMarker(boolean isBypassAutoEncryption, Map<String, Object> options) {
        if (isBypassAutoEncryption) {
            this.processBuilder = null;
            this.client = null;
            return;
        }
        if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
            this.processBuilder = MongoCryptHelper.createProcessBuilder(options);
            MongoCryptHelper.startProcess((ProcessBuilder)this.processBuilder);
        } else {
            this.processBuilder = null;
        }
        this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)((String)options.get("mongocryptdURI"))));
    }

    void mark(String databaseName, RawBsonDocument command, final SingleResultCallback<RawBsonDocument> callback) {
        Assertions.notNull((String)"client", (Object)this.client, callback);
        SingleResultCallback<RawBsonDocument> wrappedCallback = new SingleResultCallback<RawBsonDocument>(){

            public void onResult(RawBsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, (Throwable)new MongoClientException("Exception in encryption library: " + t.getMessage(), t));
                } else {
                    callback.onResult((Object)result, null);
                }
            }
        };
        this.runCommand(databaseName, command, new SingleResultCallback<RawBsonDocument>((SingleResultCallback)wrappedCallback, callback, databaseName, command){
            final /* synthetic */ SingleResultCallback val$wrappedCallback;
            final /* synthetic */ SingleResultCallback val$callback;
            final /* synthetic */ String val$databaseName;
            final /* synthetic */ RawBsonDocument val$command;
            {
                this.val$wrappedCallback = singleResultCallback;
                this.val$callback = singleResultCallback2;
                this.val$databaseName = string;
                this.val$command = rawBsonDocument;
            }

            public void onResult(RawBsonDocument result, Throwable t) {
                if (t == null) {
                    this.val$wrappedCallback.onResult((Object)result, null);
                } else if (t instanceof MongoTimeoutException && CommandMarker.this.processBuilder != null) {
                    CommandMarker.this.startProcessAndContinue((SingleResultCallback<Void>)((SingleResultCallback)new SingleResultCallback<Void>(){

                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                val$callback.onResult(null, t);
                            } else {
                                CommandMarker.this.runCommand(val$databaseName, val$command, (SingleResultCallback<RawBsonDocument>)val$wrappedCallback);
                            }
                        }
                    }));
                } else {
                    this.val$wrappedCallback.onResult(null, t);
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private void runCommand(String databaseName, RawBsonDocument command, SingleResultCallback<RawBsonDocument> callback) {
        this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)command, RawBsonDocument.class, callback);
    }

    private void startProcessAndContinue(SingleResultCallback<Void> callback) {
        try {
            MongoCryptHelper.startProcess((ProcessBuilder)this.processBuilder);
            callback.onResult(null, null);
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }
}

