/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncReadOperation;
import java.util.Collection;
import java.util.List;

abstract class MongoIterableImpl<TResult>
implements MongoIterable<TResult> {
    private final ClientSession clientSession;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private Integer batchSize;

    MongoIterableImpl(@Nullable ClientSession clientSession, OperationExecutor executor, ReadConcern readConcern, ReadPreference readPreference, boolean retryReads) {
        this.clientSession = clientSession;
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.retryReads = (Boolean)Assertions.notNull((String)"retryReads", (Object)retryReads);
    }

    abstract AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation();

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void forEach(final Block<? super TResult> block, final SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    MongoIterableImpl.this.loopCursor(batchCursor, block, (SingleResultCallback<Void>)callback);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super TResult>> void into(final A target, final SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    MongoIterableImpl.this.loopCursor(batchCursor, new Block<TResult>(){

                        public void apply(TResult t) {
                            target.add(t);
                        }
                    }, (SingleResultCallback<Void>)((SingleResultCallback)new SingleResultCallback<Void>(){

                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult((Object)target, null);
                            }
                        }
                    }));
                }
            }
        });
    }

    @Override
    public void first(final SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(final AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.setBatchSize(1);
                    batchCursor.next(new SingleResultCallback<List<TResult>>(){

                        public void onResult(List<TResult> results, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (results == null) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(results.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public MongoIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.executor.execute(this.asAsyncReadOperation(), this.readPreference, this.readConcern, this.clientSession, callback);
    }

    private void loopCursor(final AsyncBatchCursor<TResult> batchCursor, final Block<? super TResult> block, final SingleResultCallback<Void> callback) {
        batchCursor.next(new SingleResultCallback<List<TResult>>(){

            public void onResult(List<TResult> results, Throwable t) {
                if (t != null || results == null) {
                    batchCursor.close();
                    callback.onResult(null, t);
                } else {
                    try {
                        for (Object result : results) {
                            block.apply(result);
                        }
                        MongoIterableImpl.this.loopCursor(batchCursor, block, (SingleResultCallback<Void>)callback);
                    }
                    catch (Throwable tr) {
                        batchCursor.close();
                        callback.onResult(null, tr);
                    }
                }
            }
        });
    }
}

