/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientOptions;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactory;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.SSLSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.netty.NettyStreamFactory;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.management.JMXConnectionPoolListener;

public final class MongoClients {
    public static MongoClient create(MongoClientOptions settings) {
        return new MongoClientImpl(settings, MongoClients.createCluster(settings, MongoClients.getStreamFactory(settings)));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(MongoClientOptions.builder().clusterSettings(ClusterSettings.builder().applyConnectionString(connectionString).build()).connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(connectionString).build()).serverSettings(ServerSettings.builder().build()).credentialList(connectionString.getCredentialList()).sslSettings(SSLSettings.builder().applyConnectionString(connectionString).build()).socketSettings(SocketSettings.builder().applyConnectionString(connectionString).build()).build());
    }

    private static Cluster createCluster(MongoClientOptions settings, StreamFactory streamFactory) {
        StreamFactory heartbeatStreamFactory = MongoClients.getHeartbeatStreamFactory(settings);
        return new DefaultClusterFactory().create(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), null, (ConnectionPoolListener)new JMXConnectionPoolListener(), null);
    }

    private static StreamFactory getHeartbeatStreamFactory(MongoClientOptions settings) {
        return MongoClients.getStreamFactory(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
    }

    private static StreamFactory getStreamFactory(MongoClientOptions settings) {
        return MongoClients.getStreamFactory(settings.getSocketSettings(), settings.getSslSettings());
    }

    private static StreamFactory getStreamFactory(SocketSettings socketSettings, SSLSettings sslSettings) {
        String streamType = System.getProperty("org.mongodb.async.type", "nio2");
        if (streamType.equals("netty")) {
            return new NettyStreamFactory(socketSettings, sslSettings);
        }
        if (streamType.equals("nio2")) {
            if (sslSettings.isEnabled()) {
                throw new IllegalArgumentException("Unsupported stream type " + streamType + " when SSL is enabled. Please use Netty " + "instead");
            }
            return new AsynchronousSocketChannelStreamFactory(socketSettings, sslSettings);
        }
        throw new IllegalArgumentException("Unsupported stream type " + streamType);
    }

    private MongoClients() {
    }
}

