/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AwaitingWriteOperationIterable;
import com.mongodb.async.client.FindIterableImpl;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

class MapReduceIterableImpl<T>
implements MapReduceIterable<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Object scope;
    private Object filter;
    private Object sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private int batchSize;

    MapReduceIterableImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, AsyncOperationExecutor executor, String mapFunction, String reduceFunction) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.mapFunction = (String)Assertions.notNull((String)"mapFunction", (Object)mapFunction);
        this.reduceFunction = (String)Assertions.notNull((String)"reduceFunction", (Object)reduceFunction);
    }

    @Override
    public MapReduceIterable<T> collectionName(String collectionName) {
        this.collectionName = (String)Assertions.notNull((String)"collectionName", (Object)collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public MapReduceIterable<T> finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public MapReduceIterable<T> scope(Object scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MapReduceIterable<T> sort(Object sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public MapReduceIterable<T> filter(Object filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public MapReduceIterable<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public MapReduceIterable<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public MapReduceIterable<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MapReduceIterable<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceIterable<T> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public MapReduceIterable<T> databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public MapReduceIterable<T> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    public MapReduceIterable<T> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public MapReduceIterable<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public void toCollection(final SingleResultCallback<Void> callback) {
        if (this.inline) {
            throw new IllegalArgumentException("The options must specify a non-inline result");
        }
        this.executor.execute((AsyncWriteOperation)this.createMapReduceToCollectionOperation(), (SingleResultCallback)new SingleResultCallback<MapReduceStatistics>(){

            public void onResult(MapReduceStatistics result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void first(SingleResultCallback<T> callback) {
        this.execute().first(callback);
    }

    @Override
    public void forEach(Block<? super T> block, SingleResultCallback<Void> callback) {
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super T>> void into(A target, SingleResultCallback<A> callback) {
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.execute().batchCursor(callback);
    }

    MongoIterable<T> execute() {
        if (this.inline) {
            MapReduceWithInlineResultsOperation operation = new MapReduceWithInlineResultsOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), (Decoder)this.codecRegistry.get(this.clazz)).filter(this.asBson(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.asBson(this.scope)).sort(this.asBson(this.sort)).verbose(this.verbose);
            if (this.finalizeFunction != null) {
                operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
            }
            return new OperationIterable(operation, this.readPreference, this.executor);
        }
        MapReduceToCollectionOperation operation = this.createMapReduceToCollectionOperation();
        String dbName = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        MongoIterable delegated = new FindIterableImpl<T>(new MongoNamespace(dbName, this.collectionName), this.clazz, this.codecRegistry, ReadPreference.primary(), this.executor, new BsonDocument(), new FindOptions()).batchSize(this.batchSize);
        return new AwaitingWriteOperationIterable(operation, this.executor, delegated);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument((Object)document, (CodecRegistry)this.codecRegistry);
    }

    private MapReduceToCollectionOperation createMapReduceToCollectionOperation() {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.collectionName).filter(this.asBson(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.asBson(this.scope)).sort(this.asBson(this.sort)).verbose(this.verbose).action(this.action.getValue()).nonAtomic(this.nonAtomic).sharded(this.sharded).databaseName(this.databaseName);
        if (this.finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
        }
        return operation;
    }
}

