/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.AwaitingWriteOperationIterable;
import com.mongodb.async.client.FindIterableImpl;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncWriteOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

class AggregateIterableImpl<T>
implements AggregateIterable<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private final List<?> pipeline;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private long maxTimeMS;
    private Boolean useCursor;

    AggregateIterableImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, AsyncOperationExecutor executor, List<?> pipeline) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
    }

    @Override
    public AggregateIterable<T> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public AggregateIterable<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<T> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public void toCollection(SingleResultCallback<Void> callback) {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue outCollection = this.getAggregateOutCollection(aggregateList);
        if (outCollection == null) {
            throw new IllegalArgumentException("The last stage of the aggregation pipeline must be $out");
        }
        this.executor.execute((AsyncWriteOperation)new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse), callback);
    }

    @Override
    public void first(SingleResultCallback<T> callback) {
        this.execute().first(callback);
    }

    @Override
    public void forEach(Block<? super T> block, SingleResultCallback<Void> callback) {
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super T>> void into(A target, SingleResultCallback<A> callback) {
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.execute().batchCursor(callback);
    }

    private MongoIterable<T> execute() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue outCollection = this.getAggregateOutCollection(aggregateList);
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse);
            FindIterableImpl<T> delegated = new FindIterableImpl<T>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), this.clazz, this.codecRegistry, ReadPreference.primary(), this.executor, new BsonDocument(), new FindOptions());
            if (this.batchSize != null) {
                delegated.batchSize(this.batchSize);
            }
            return new AwaitingWriteOperationIterable(operation, this.executor, delegated);
        }
        return new OperationIterable(new AggregateOperation(this.namespace, aggregateList, (Decoder)this.codecRegistry.get(this.clazz)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize).useCursor(this.useCursor), this.readPreference, this.executor);
    }

    private BsonValue getAggregateOutCollection(List<BsonDocument> aggregateList) {
        return aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get((Object)"$out");
    }

    private <D> List<BsonDocument> createBsonDocumentList(List<D> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (D obj : pipeline) {
            aggregateList.add(BsonDocumentWrapper.asBsonDocument(obj, (CodecRegistry)this.codecRegistry));
        }
        return aggregateList;
    }
}

