/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.internal.crypt.capi.BinaryHolder;
import com.mongodb.internal.crypt.capi.CAPI;
import com.mongodb.internal.crypt.capi.CAPIHelper;
import com.mongodb.internal.crypt.capi.MongoKeyDecryptor;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import org.bson.assertions.Assertions;

class MongoKeyDecryptorImpl
implements MongoKeyDecryptor {
    private final CAPI.mongocrypt_kms_ctx_t wrapped;

    MongoKeyDecryptorImpl(CAPI.mongocrypt_kms_ctx_t wrapped) {
        Assertions.notNull((String)"wrapped", (Object)((Object)wrapped));
        this.wrapped = wrapped;
    }

    @Override
    public String getKmsProvider() {
        return CAPI.mongocrypt_kms_ctx_get_kms_provider(this.wrapped, null).toString();
    }

    @Override
    public String getHostName() {
        PointerByReference hostNamePointerByReference = new PointerByReference();
        boolean success = CAPI.mongocrypt_kms_ctx_endpoint(this.wrapped, hostNamePointerByReference);
        if (!success) {
            this.throwExceptionFromStatus();
        }
        Pointer hostNamePointer = hostNamePointerByReference.getValue();
        return hostNamePointer.getString(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getMessage() {
        CAPI.mongocrypt_binary_t binary = CAPI.mongocrypt_binary_new();
        try {
            boolean success = CAPI.mongocrypt_kms_ctx_message(this.wrapped, binary);
            if (!success) {
                this.throwExceptionFromStatus();
            }
            ByteBuffer byteBuffer = CAPIHelper.toByteBuffer(binary);
            return byteBuffer;
        }
        finally {
            CAPI.mongocrypt_binary_destroy(binary);
        }
    }

    @Override
    public int bytesNeeded() {
        return CAPI.mongocrypt_kms_ctx_bytes_needed(this.wrapped);
    }

    @Override
    public void feed(ByteBuffer bytes) {
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(bytes);){
            boolean success = CAPI.mongocrypt_kms_ctx_feed(this.wrapped, binaryHolder.getBinary());
            if (!success) {
                this.throwExceptionFromStatus();
            }
        }
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_kms_ctx_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(CAPI.mongocrypt_status_message(status, null).toString(), CAPI.mongocrypt_status_code(status));
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }
}

