/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.MongoCryptException;
import java.util.Objects;
import org.bson.BsonBinary;

public class MongoExplicitEncryptOptions {
    private final BsonBinary keyId;
    private final String keyAltName;
    private final String algorithm;
    private final Long contentionFactor;
    private final QueryType queryType;

    public static Builder builder() {
        return new Builder();
    }

    public BsonBinary getKeyId() {
        return this.keyId;
    }

    public String getKeyAltName() {
        return this.keyAltName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Long getContentionFactor() {
        return this.contentionFactor;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    private MongoExplicitEncryptOptions(Builder builder) {
        this.keyId = builder.keyId;
        this.keyAltName = builder.keyAltName;
        this.algorithm = builder.algorithm;
        this.contentionFactor = builder.contentionFactor;
        this.queryType = builder.queryType;
        if (!Objects.equals(this.algorithm, "Indexed")) {
            if (this.contentionFactor != null) {
                throw new IllegalStateException("Invalid configuration, contentionFactor can only be set if algorithm is 'Indexed'");
            }
            if (this.queryType != null) {
                throw new IllegalStateException("Invalid configuration, queryType can only be set if algorithm is 'Indexed'");
            }
        }
    }

    public String toString() {
        return "MongoExplicitEncryptOptions{keyId=" + this.keyId + ", keyAltName='" + this.keyAltName + '\'' + ", algorithm='" + this.algorithm + '\'' + ", contentionFactor=" + this.contentionFactor + ", queryType=" + (Object)((Object)this.queryType) + '}';
    }

    public static class Builder {
        private BsonBinary keyId;
        private String keyAltName;
        private String algorithm;
        private Long contentionFactor;
        private QueryType queryType;

        private Builder() {
        }

        public Builder keyId(BsonBinary keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder keyAltName(String keyAltName) {
            this.keyAltName = keyAltName;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder contentionFactor(Long contentionFactor) {
            this.contentionFactor = contentionFactor;
            return this;
        }

        public Builder queryType(QueryType queryType) {
            this.queryType = queryType;
            return this;
        }

        public MongoExplicitEncryptOptions build() {
            return new MongoExplicitEncryptOptions(this);
        }
    }

    public static enum QueryType {
        EQUALITY(1);

        private final int queryType;

        private QueryType(int queryType) {
            this.queryType = queryType;
        }

        public int getQueryType() {
            return this.queryType;
        }

        public static QueryType fromInteger(int queryType) {
            for (QueryType value : QueryType.values()) {
                if (value.queryType != queryType) continue;
                return value;
            }
            throw new MongoCryptException("Unknown context queryType " + queryType);
        }
    }
}

