/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.MongoAwsKmsProviderOptions;
import com.mongodb.crypt.capi.MongoLocalKmsProviderOptions;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.assertions.Assertions;

public class MongoCryptOptions {
    private final MongoAwsKmsProviderOptions awsKmsProviderOptions;
    private final MongoLocalKmsProviderOptions localKmsProviderOptions;
    private final BsonDocument kmsProviderOptions;
    private final Map<String, BsonDocument> localSchemaMap;

    public static Builder builder() {
        return new Builder();
    }

    public MongoAwsKmsProviderOptions getAwsKmsProviderOptions() {
        return this.awsKmsProviderOptions;
    }

    public MongoLocalKmsProviderOptions getLocalKmsProviderOptions() {
        return this.localKmsProviderOptions;
    }

    public BsonDocument getKmsProviderOptions() {
        return this.kmsProviderOptions;
    }

    public Map<String, BsonDocument> getLocalSchemaMap() {
        return this.localSchemaMap;
    }

    private MongoCryptOptions(Builder builder) {
        Assertions.isTrue((String)"at least one KMS provider is configured", (builder.awsKmsProviderOptions != null || builder.localKmsProviderOptions != null || builder.kmsProviderOptions != null ? 1 : 0) != 0);
        this.awsKmsProviderOptions = builder.awsKmsProviderOptions;
        this.localKmsProviderOptions = builder.localKmsProviderOptions;
        this.kmsProviderOptions = builder.kmsProviderOptions;
        this.localSchemaMap = builder.localSchemaMap;
    }

    public static class Builder {
        private MongoAwsKmsProviderOptions awsKmsProviderOptions;
        private MongoLocalKmsProviderOptions localKmsProviderOptions;
        private BsonDocument kmsProviderOptions = null;
        private Map<String, BsonDocument> localSchemaMap = null;

        private Builder() {
        }

        public Builder awsKmsProviderOptions(MongoAwsKmsProviderOptions awsKmsProviderOptions) {
            this.awsKmsProviderOptions = awsKmsProviderOptions;
            return this;
        }

        public Builder localKmsProviderOptions(MongoLocalKmsProviderOptions localKmsProviderOptions) {
            this.localKmsProviderOptions = localKmsProviderOptions;
            return this;
        }

        public Builder kmsProviderOptions(BsonDocument kmsProviderOptions) {
            this.kmsProviderOptions = kmsProviderOptions;
            return this;
        }

        public Builder localSchemaMap(Map<String, BsonDocument> localSchemaMap) {
            this.localSchemaMap = localSchemaMap;
            return this;
        }

        public MongoCryptOptions build() {
            return new MongoCryptOptions(this);
        }
    }
}

