/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;

@Immutable
public final class TransactionOptions {
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;

    @Nullable
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Nullable
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransactionOptions merge(TransactionOptions options, TransactionOptions defaultOptions) {
        Assertions.notNull("options", options);
        Assertions.notNull("defaultOptions", defaultOptions);
        return TransactionOptions.builder().writeConcern(options.getWriteConcern() == null ? defaultOptions.getWriteConcern() : options.getWriteConcern()).readConcern(options.getReadConcern() == null ? defaultOptions.getReadConcern() : options.getReadConcern()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)o;
        if (this.readConcern != null ? !this.readConcern.equals(that.readConcern) : that.readConcern != null) {
            return false;
        }
        return !(this.writeConcern != null ? !this.writeConcern.equals(that.writeConcern) : that.writeConcern != null);
    }

    public int hashCode() {
        int result = this.readConcern != null ? this.readConcern.hashCode() : 0;
        result = 31 * result + (this.writeConcern != null ? this.writeConcern.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TransactionOptions{readConcern=" + this.readConcern + ", writeConcern=" + this.writeConcern + '}';
    }

    private TransactionOptions(Builder builder) {
        this.readConcern = builder.readConcern;
        this.writeConcern = builder.writeConcern;
    }

    public static final class Builder {
        private ReadConcern readConcern;
        private WriteConcern writeConcern;

        public Builder readConcern(@Nullable ReadConcern readConcern) {
            this.readConcern = readConcern;
            return this;
        }

        public Builder writeConcern(@Nullable WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
            Assertions.isTrueArgument("acknowledged write concern", writeConcern != null && writeConcern.isAcknowledged());
            return this;
        }

        public TransactionOptions build() {
            return new TransactionOptions(this);
        }

        private Builder() {
        }
    }
}

