/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.binding.ReadBinding;
import com.mongodb.connection.Connection;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.WriteConcernHelper;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

public abstract class TransactionOperation
implements ReadOperation<Void> {
    private final WriteConcern writeConcern;

    protected TransactionOperation(WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(final ReadBinding binding) {
        Assertions.isTrue("in transaction", binding.getSessionContext().hasActiveTransaction());
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                CommandOperationHelper.executeWrappedCommandProtocol(binding, "admin", TransactionOperation.this.getCommand(binding), connection, WriteConcernHelper.writeConcernErrorTransformer());
                return null;
            }
        });
    }

    private BsonDocument getCommand(ReadBinding binding) {
        BsonDocument command = new BsonDocument(this.getCommandName(), new BsonInt32(1));
        if (!this.getWriteConcern().isServerDefault()) {
            command.put("writeConcern", this.getWriteConcern().asDocument());
        }
        return command;
    }

    protected abstract String getCommandName();
}

