/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.BsonWriterHelper;
import com.mongodb.connection.ByteBufBsonDocument;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.OpCode;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.ServerVersion;
import com.mongodb.connection.SplittablePayload;
import com.mongodb.connection.SplittablePayloadBsonWriter;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.session.SessionContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonString;
import org.bson.BsonWriter;
import org.bson.FieldNameValidator;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonOutput;

final class CommandMessage
extends RequestMessage {
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final FieldNameValidator commandFieldNameValidator;
    private final ReadPreference readPreference;
    private final SplittablePayload payload;
    private final FieldNameValidator payloadFieldNameValidator;
    private final boolean responseExpected;

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, true, null, null);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator) {
        super(namespace.getFullName(), CommandMessage.getOpCode(settings), settings);
        this.namespace = namespace;
        this.command = command;
        this.commandFieldNameValidator = commandFieldNameValidator;
        this.readPreference = readPreference;
        this.responseExpected = responseExpected;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
    }

    BsonDocument getCommandDocument(ByteBufferBsonOutput bsonOutput) {
        BsonDocument commandBsonDocument;
        ByteBufBsonDocument byteBufBsonDocument = ByteBufBsonDocument.createOne(bsonOutput, this.getEncodingMetadata().getFirstDocumentPosition());
        if (this.useOpMsg() && this.containsPayload()) {
            commandBsonDocument = byteBufBsonDocument.toBsonDocument();
            int payloadStartPosition = this.getEncodingMetadata().getFirstDocumentPosition() + byteBufBsonDocument.getSizeInBytes() + 1 + 4 + this.payload.getPayloadName().getBytes(Charset.forName("UTF-8")).length + 1;
            commandBsonDocument.append(this.payload.getPayloadName(), new BsonArray(ByteBufBsonDocument.createList(bsonOutput, payloadStartPosition)));
        } else {
            commandBsonDocument = byteBufBsonDocument;
        }
        if (commandBsonDocument.containsKey("$query")) {
            commandBsonDocument = commandBsonDocument.getDocument("$query");
        }
        return commandBsonDocument;
    }

    boolean containsPayload() {
        return this.payload != null;
    }

    boolean isResponseExpected() {
        Assertions.isTrue("The message must be encoded before determining if a response is expected", this.getEncodingMetadata() != null);
        return this.calculateIsResponseExpected();
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, SessionContext sessionContext) {
        int commandStartPosition;
        if (this.useOpMsg()) {
            int flagPosition = bsonOutput.getPosition();
            bsonOutput.writeInt32(0);
            bsonOutput.writeByte(0);
            commandStartPosition = bsonOutput.getPosition();
            this.addDocument(this.getCommandToEncode(), bsonOutput, this.commandFieldNameValidator, this.getExtraElements(sessionContext));
            if (this.payload != null) {
                bsonOutput.writeByte(1);
                int payloadPosition = bsonOutput.getPosition();
                bsonOutput.writeInt32(0);
                bsonOutput.writeCString(this.payload.getPayloadName());
                BsonWriterHelper.writePayload(new BsonBinaryWriter(bsonOutput, this.payloadFieldNameValidator), bsonOutput, this.getSettings(), commandStartPosition, this.payload);
                int payloadLength = bsonOutput.getPosition() - payloadPosition;
                bsonOutput.writeInt32(payloadPosition, payloadLength);
            }
            bsonOutput.writeInt32(flagPosition, this.getFlagBits());
        } else {
            bsonOutput.writeInt32(0);
            bsonOutput.writeCString(this.namespace.getFullName());
            bsonOutput.writeInt32(0);
            bsonOutput.writeInt32(-1);
            commandStartPosition = bsonOutput.getPosition();
            if (this.payload == null) {
                this.addDocument(this.getCommandToEncode(), bsonOutput, this.commandFieldNameValidator, null);
            } else {
                this.addDocumentWithPayload(bsonOutput);
            }
        }
        return new RequestMessage.EncodingMetadata(commandStartPosition);
    }

    private FieldNameValidator getPayloadArrayFieldNameValidator() {
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put(this.payload.getPayloadName(), this.payloadFieldNameValidator);
        return new MappedFieldNameValidator(this.commandFieldNameValidator, rootMap);
    }

    private void addDocumentWithPayload(BsonOutput bsonOutput) {
        BsonWriter writer = new BsonBinaryWriter(bsonOutput, this.getPayloadArrayFieldNameValidator());
        if (this.payload != null) {
            writer = new SplittablePayloadBsonWriter(writer, bsonOutput, this.getSettings(), this.payload);
        }
        BsonDocument commandToEncode = this.getCommandToEncode();
        this.getCodec(commandToEncode).encode(writer, commandToEncode, EncoderContext.builder().build());
    }

    private int getFlagBits() {
        if (this.calculateIsResponseExpected()) {
            return 0;
        }
        return 2;
    }

    private boolean calculateIsResponseExpected() {
        if (!this.responseExpected && this.useOpMsg() && this.payload != null && this.payload.hasAnotherSplit()) {
            return true;
        }
        return this.responseExpected;
    }

    private boolean useOpMsg() {
        return this.getOpCode().equals((Object)OpCode.OP_MSG);
    }

    private BsonDocument getCommandToEncode() {
        BsonDocument commandToEncode = this.command;
        if (!this.useOpMsg() && !this.isDefaultReadPreference(this.getReadPreference())) {
            commandToEncode = new BsonDocument("$query", this.command).append("$readPreference", this.getReadPreference().toDocument());
        }
        return commandToEncode;
    }

    private List<BsonElement> getExtraElements(SessionContext sessionContext) {
        ArrayList<BsonElement> extraElements = new ArrayList<BsonElement>();
        extraElements.add(new BsonElement("$db", new BsonString(new MongoNamespace(this.getCollectionName()).getDatabaseName())));
        if (sessionContext.getClusterTime() != null) {
            extraElements.add(new BsonElement("$clusterTime", sessionContext.getClusterTime()));
        }
        if (sessionContext.hasSession()) {
            extraElements.add(new BsonElement("lsid", sessionContext.getSessionId()));
        }
        if (!this.isDefaultReadPreference(this.getReadPreference())) {
            extraElements.add(new BsonElement("$readPreference", this.getReadPreference().toDocument()));
        }
        return extraElements;
    }

    private boolean isDefaultReadPreference(ReadPreference readPreference) {
        return readPreference.equals(ReadPreference.primary());
    }

    private static OpCode getOpCode(MessageSettings settings) {
        return CommandMessage.isServerVersionAtLeastThreeDotSix(settings) ? OpCode.OP_MSG : OpCode.OP_QUERY;
    }

    private static boolean isServerVersionAtLeastThreeDotSix(MessageSettings settings) {
        return settings.getServerVersion().compareTo(new ServerVersion(3, 6)) >= 0;
    }
}

