/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.TagSet;
import com.mongodb.TaggableReadPreference;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;

@Immutable
public abstract class ReadPreference {
    private static final ReadPreference PRIMARY = new PrimaryReadPreference();
    private static final ReadPreference SECONDARY = new TaggableReadPreference.SecondaryReadPreference();
    private static final ReadPreference SECONDARY_PREFERRED = new TaggableReadPreference.SecondaryPreferredReadPreference();
    private static final ReadPreference PRIMARY_PREFERRED = new TaggableReadPreference.PrimaryPreferredReadPreference();
    private static final ReadPreference NEAREST = new TaggableReadPreference.NearestReadPreference();

    ReadPreference() {
    }

    public abstract boolean isSlaveOk();

    public abstract String getName();

    public abstract BsonDocument toDocument();

    public final List<ServerDescription> choose(ClusterDescription clusterDescription) {
        switch (clusterDescription.getType()) {
            case REPLICA_SET: {
                return this.chooseForReplicaSet(clusterDescription);
            }
            case SHARDED: 
            case STANDALONE: {
                return this.chooseForNonReplicaSet(clusterDescription);
            }
            case UNKNOWN: {
                return Collections.emptyList();
            }
        }
        throw new UnsupportedOperationException("Unsupported cluster type: " + (Object)((Object)clusterDescription.getType()));
    }

    protected abstract List<ServerDescription> chooseForNonReplicaSet(ClusterDescription var1);

    protected abstract List<ServerDescription> chooseForReplicaSet(ClusterDescription var1);

    public static ReadPreference primary() {
        return PRIMARY;
    }

    public static ReadPreference primaryPreferred() {
        return PRIMARY_PREFERRED;
    }

    public static ReadPreference secondary() {
        return SECONDARY;
    }

    public static ReadPreference secondaryPreferred() {
        return SECONDARY_PREFERRED;
    }

    public static ReadPreference nearest() {
        return NEAREST;
    }

    public static ReadPreference primaryPreferred(long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(Collections.<TagSet>emptyList(), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static ReadPreference secondary(long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryReadPreference(Collections.<TagSet>emptyList(), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static ReadPreference secondaryPreferred(long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(Collections.<TagSet>emptyList(), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static ReadPreference nearest(long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.NearestReadPreference(Collections.<TagSet>emptyList(), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference primaryPreferred(TagSet tagSet) {
        return ReadPreference.primaryPreferred(tagSet, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondary(TagSet tagSet) {
        return ReadPreference.secondary(tagSet, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondaryPreferred(TagSet tagSet) {
        return ReadPreference.secondaryPreferred(tagSet, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference nearest(TagSet tagSet) {
        return ReadPreference.nearest(tagSet, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference primaryPreferred(TagSet tagSet, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(Collections.singletonList(tagSet), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference secondary(TagSet tagSet, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryReadPreference(Collections.singletonList(tagSet), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference secondaryPreferred(TagSet tagSet, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(Collections.singletonList(tagSet), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference nearest(TagSet tagSet, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.NearestReadPreference(Collections.singletonList(tagSet), TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference primaryPreferred(List<TagSet> tagSetList) {
        return ReadPreference.primaryPreferred(tagSetList, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondary(List<TagSet> tagSetList) {
        return ReadPreference.secondary(tagSetList, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondaryPreferred(List<TagSet> tagSetList) {
        return ReadPreference.secondaryPreferred(tagSetList, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference nearest(List<TagSet> tagSetList) {
        return ReadPreference.nearest(tagSetList, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference primaryPreferred(List<TagSet> tagSetList, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(tagSetList, TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference secondary(List<TagSet> tagSetList, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryReadPreference(tagSetList, TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference secondaryPreferred(List<TagSet> tagSetList, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(tagSetList, TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static TaggableReadPreference nearest(List<TagSet> tagSetList, long maxStaleness, TimeUnit timeUnit) {
        return new TaggableReadPreference.NearestReadPreference(tagSetList, TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
    }

    public static ReadPreference valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String nameToCheck = name.toLowerCase();
        if (nameToCheck.equals(PRIMARY.getName().toLowerCase())) {
            return PRIMARY;
        }
        if (nameToCheck.equals(SECONDARY.getName().toLowerCase())) {
            return SECONDARY;
        }
        if (nameToCheck.equals(SECONDARY_PREFERRED.getName().toLowerCase())) {
            return SECONDARY_PREFERRED;
        }
        if (nameToCheck.equals(PRIMARY_PREFERRED.getName().toLowerCase())) {
            return PRIMARY_PREFERRED;
        }
        if (nameToCheck.equals(NEAREST.getName().toLowerCase())) {
            return NEAREST;
        }
        throw new IllegalArgumentException("No match for read preference of " + name);
    }

    public static TaggableReadPreference valueOf(String name, List<TagSet> tagSetList) {
        return ReadPreference.valueOf(name, tagSetList, 0L, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference valueOf(String name, List<TagSet> tagSetList, long maxStaleness, TimeUnit timeUnit) {
        Assertions.notNull("name", name);
        Assertions.notNull("tagSetList", tagSetList);
        Assertions.notNull("timeUnit", timeUnit);
        String nameToCheck = name.toLowerCase();
        if (nameToCheck.equals(PRIMARY.getName().toLowerCase())) {
            throw new IllegalArgumentException("Primary read preference can not also specify tag sets or max staleness");
        }
        long maxStalenessMS = TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit);
        if (nameToCheck.equals(SECONDARY.getName().toLowerCase())) {
            return new TaggableReadPreference.SecondaryReadPreference(tagSetList, maxStalenessMS);
        }
        if (nameToCheck.equals(SECONDARY_PREFERRED.getName().toLowerCase())) {
            return new TaggableReadPreference.SecondaryPreferredReadPreference(tagSetList, maxStalenessMS);
        }
        if (nameToCheck.equals(PRIMARY_PREFERRED.getName().toLowerCase())) {
            return new TaggableReadPreference.PrimaryPreferredReadPreference(tagSetList, maxStalenessMS);
        }
        if (nameToCheck.equals(NEAREST.getName().toLowerCase())) {
            return new TaggableReadPreference.NearestReadPreference(tagSetList, maxStalenessMS);
        }
        throw new IllegalArgumentException("No match for read preference of " + name);
    }

    private static final class PrimaryReadPreference
    extends ReadPreference {
        private PrimaryReadPreference() {
        }

        @Override
        public boolean isSlaveOk() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public BsonDocument toDocument() {
            return new BsonDocument("mode", new BsonString(this.getName()));
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            return clusterDescription.getPrimaries();
        }

        @Override
        protected List<ServerDescription> chooseForNonReplicaSet(ClusterDescription clusterDescription) {
            return clusterDescription.getAny();
        }

        @Override
        public String getName() {
            return "primary";
        }
    }
}

