/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ReadBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamLevel;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.operation.AggregateOperationImpl;
import com.mongodb.operation.AsyncChangeStreamBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.ChangeStreamBatchCursor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.session.SessionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;

@Deprecated
public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final AggregateOperationImpl<RawBsonDocument> wrapped;
    private final FullDocument fullDocument;
    private final Decoder<T> decoder;
    private final ChangeStreamLevel changeStreamLevel;
    private BsonDocument resumeToken;
    private BsonDocument startAfter;
    private BsonTimestamp startAtOperationTime;
    private BsonTimestamp startAtOperationTimeForResume;

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this(namespace, fullDocument, pipeline, decoder, ChangeStreamLevel.COLLECTION);
    }

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, List<BsonDocument> pipeline, Decoder<T> decoder, ChangeStreamLevel changeStreamLevel) {
        this.wrapped = new AggregateOperationImpl<RawBsonDocument>(namespace, pipeline, RAW_BSON_DOCUMENT_CODEC, this.getAggregateTarget(), this.getPipelineCreator());
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.changeStreamLevel = Assertions.notNull("changeStreamLevel", changeStreamLevel);
    }

    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument resumeToken) {
        this.resumeToken = resumeToken;
        return this;
    }

    public BsonDocument getStartAfter() {
        return this.startAfter;
    }

    public ChangeStreamOperation<T> startAfter(BsonDocument startAfter) {
        this.startAfter = startAfter;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public ChangeStreamOperation<T> batchSize(Integer batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        return this.wrapped.getMaxAwaitTime(timeUnit);
    }

    public ChangeStreamOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public ChangeStreamOperation<T> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = startAtOperationTime;
        return this;
    }

    ChangeStreamOperation<T> startOperationTimeForResume(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTimeForResume = startAtOperationTime;
        return this;
    }

    public BsonTimestamp getStartAtOperationTime() {
        return this.startAtOperationTime;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return new ChangeStreamBatchCursor(this, (BatchCursor<RawBsonDocument>)this.wrapped.execute(binding), binding);
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.wrapped.executeAsync(binding, new SingleResultCallback<AsyncBatchCursor<RawBsonDocument>>(){

            @Override
            public void onResult(AsyncBatchCursor<RawBsonDocument> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncChangeStreamBatchCursor(ChangeStreamOperation.this, result, binding), null);
                }
            }
        });
    }

    private AggregateOperationImpl.AggregateTarget getAggregateTarget() {
        return new AggregateOperationImpl.AggregateTarget(){

            @Override
            public BsonValue create() {
                return ChangeStreamOperation.this.changeStreamLevel == ChangeStreamLevel.COLLECTION ? new BsonString(ChangeStreamOperation.this.getNamespace().getCollectionName()) : new BsonInt32(1);
            }
        };
    }

    private AggregateOperationImpl.PipelineCreator getPipelineCreator() {
        return new AggregateOperationImpl.PipelineCreator(){

            @Override
            public BsonArray create(ConnectionDescription description, SessionContext sessionContext) {
                ArrayList<BsonDocument> changeStreamPipeline = new ArrayList<BsonDocument>();
                BsonDocument changeStream = new BsonDocument("fullDocument", new BsonString(ChangeStreamOperation.this.fullDocument.getValue()));
                if (ChangeStreamOperation.this.changeStreamLevel == ChangeStreamLevel.CLIENT) {
                    changeStream.append("allChangesForCluster", BsonBoolean.TRUE);
                }
                boolean hasResumeSetting = false;
                if (ChangeStreamOperation.this.resumeToken != null) {
                    hasResumeSetting = true;
                    changeStream.append("resumeAfter", ChangeStreamOperation.this.resumeToken);
                }
                if (ChangeStreamOperation.this.startAfter != null) {
                    hasResumeSetting = true;
                    changeStream.append("startAfter", ChangeStreamOperation.this.startAfter);
                }
                if (ChangeStreamOperation.this.startAtOperationTime != null) {
                    hasResumeSetting = true;
                    changeStream.append("startAtOperationTime", ChangeStreamOperation.this.startAtOperationTime);
                }
                if (!hasResumeSetting && ChangeStreamOperation.this.startAtOperationTimeForResume != null && ServerVersionHelper.serverIsAtLeastVersionFourDotZero(description)) {
                    changeStream.append("startAtOperationTime", ChangeStreamOperation.this.startAtOperationTimeForResume);
                }
                changeStreamPipeline.add(new BsonDocument("$changeStream", changeStream));
                changeStreamPipeline.addAll(ChangeStreamOperation.this.getPipeline());
                return new BsonArray(changeStreamPipeline);
            }
        };
    }
}

