/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.concurrent.TimeUnit;

public class MapReduceOptions {
    private final boolean inline;
    private final String collectionName;
    private String finalizeFunction;
    private Object scope;
    private Object filter;
    private Object sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private Action action;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;

    public MapReduceOptions() {
        this.collectionName = null;
        this.inline = true;
    }

    public MapReduceOptions(String collectionName) {
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.action = Action.REPLACE;
        this.inline = false;
    }

    public boolean isInline() {
        return this.inline;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceOptions finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public Object getScope() {
        return this.scope;
    }

    public MapReduceOptions scope(Object scope) {
        this.scope = scope;
        return this;
    }

    public Object getSort() {
        return this.sort;
    }

    public MapReduceOptions sort(Object sort) {
        this.sort = sort;
        return this;
    }

    public MapReduceOptions filter(Object filter) {
        this.filter = filter;
        return this;
    }

    public Object getFilter() {
        return this.filter;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceOptions jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceOptions verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public MapReduceOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Action getAction() {
        return this.action;
    }

    public MapReduceOptions action(Action action) {
        this.action = Assertions.notNull("action", action);
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public MapReduceOptions databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public boolean isSharded() {
        return this.sharded;
    }

    public MapReduceOptions sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    public boolean isNonAtomic() {
        return this.nonAtomic;
    }

    public MapReduceOptions nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    public static enum Action {
        REPLACE("replace"),
        MERGE("merge"),
        REDUCE("reduce");

        private final String value;

        private Action(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

