/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListIndexesFluent;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.ListIndexesOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

final class ListIndexesFluentImpl<T>
implements ListIndexesFluent<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private int batchSize;
    private long maxTimeMS;

    ListIndexesFluentImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.clazz = Assertions.notNull("clazz", clazz);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public ListIndexesFluent<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesFluent<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return this.execute().map(mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        return new OperationIterable(this.createListIndexesOperation(), this.readPreference, this.executor);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private ListIndexesOperation<T> createListIndexesOperation() {
        return new ListIndexesOperation<T>(this.namespace, this.getCodec(this.clazz)).batchSize(this.batchSize).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }
}

