/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBPort;
import com.mongodb.InUseConnectionBean;
import com.mongodb.MongoConnectionPoolMXBean;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.util.ConnectionPoolStatisticsBean;
import com.mongodb.util.SimplePool;
import com.mongodb.util.management.JMException;
import com.mongodb.util.management.MBeanServerFactory;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPortPool
extends SimplePool<DBPort>
implements MongoConnectionPoolMXBean {
    final MongoOptions _options;
    private final Semaphore _waitingSem;
    final ServerAddress _addr;
    boolean _everWorked = false;

    @Override
    public String getHost() {
        return this._addr.getHost();
    }

    @Override
    public int getPort() {
        return this._addr.getPort();
    }

    @Override
    public synchronized ConnectionPoolStatisticsBean getStatistics() {
        return new ConnectionPoolStatisticsBean(this.getTotal(), this.getInUse(), this.getInUseConnections());
    }

    private InUseConnectionBean[] getInUseConnections() {
        ArrayList<InUseConnectionBean> inUseConnectionInfoList = new ArrayList<InUseConnectionBean>();
        long currentNanoTime = System.nanoTime();
        for (DBPort port : this._out) {
            inUseConnectionInfoList.add(new InUseConnectionBean(port, currentNanoTime));
        }
        return inUseConnectionInfoList.toArray(new InUseConnectionBean[inUseConnectionInfoList.size()]);
    }

    DBPortPool(ServerAddress addr, MongoOptions options) {
        super("DBPortPool-" + addr.toString() + ", options = " + options.toString(), options.connectionsPerHost);
        this._options = options;
        this._addr = addr;
        this._waitingSem = new Semaphore(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
    }

    protected long memSize(DBPort p) {
        return 0L;
    }

    @Override
    protected int pick(int recommended, boolean couldCreate) {
        int id = System.identityHashCode(Thread.currentThread());
        for (int i = this._avail.size() - 1; i >= 0; --i) {
            if (((DBPort)this._avail.get((int)i))._lastThread != id) continue;
            return i;
        }
        return couldCreate ? -1 : recommended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBPort get() {
        DBPort port = null;
        if (!this._waitingSem.tryAcquire()) {
            throw new SemaphoresOut();
        }
        try {
            port = (DBPort)this.get(this._options.maxWaitTime);
        }
        finally {
            this._waitingSem.release();
        }
        if (port == null) {
            throw new ConnectionWaitTimeOut(this._options.maxWaitTime);
        }
        port._lastThread = System.identityHashCode(Thread.currentThread());
        return port;
    }

    boolean gotError(Exception e) {
        DBPort temp;
        if (e instanceof ClosedByInterruptException || e instanceof InterruptedException) {
            return true;
        }
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        Bytes.LOGGER.log(Level.WARNING, "emptying DBPortPool to " + this.getServerAddress() + " b/c of error", e);
        ArrayList<DBPort> all = new ArrayList<DBPort>();
        while ((temp = (DBPort)this.get(0L)) != null) {
            all.add(temp);
        }
        for (DBPort p : all) {
            p.close();
            this.done(p);
        }
        return false;
    }

    @Override
    public void cleanup(DBPort p) {
        p.close();
    }

    @Override
    protected DBPort createNew() {
        return new DBPort(this._addr, this, this._options);
    }

    public ServerAddress getServerAddress() {
        return this._addr;
    }

    public static class ConnectionWaitTimeOut
    extends NoMoreConnection {
        private static final long serialVersionUID = -4415279469780082174L;

        ConnectionWaitTimeOut(int timeout) {
            super("Connection wait timeout after " + timeout + " ms");
        }
    }

    public static class SemaphoresOut
    extends NoMoreConnection {
        private static final long serialVersionUID = -4415279469780082174L;

        SemaphoresOut() {
            super("Out of semaphores to get db connection");
        }
    }

    public static class NoMoreConnection
    extends MongoInternalException {
        private static final long serialVersionUID = -4415279469780082174L;

        NoMoreConnection(String msg) {
            super(msg);
        }
    }

    static class Holder {
        final MongoOptions _options;
        final Map<ServerAddress, DBPortPool> _pools = Collections.synchronizedMap(new HashMap());
        final int _serial = nextSerial.incrementAndGet();
        static AtomicInteger nextSerial = new AtomicInteger(0);

        Holder(MongoOptions options) {
            this._options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DBPortPool get(ServerAddress addr) {
            DBPortPool p = this._pools.get(addr);
            if (p != null) {
                return p;
            }
            Map<ServerAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                p = this._pools.get(addr);
                if (p != null) {
                    return p;
                }
                p = new DBPortPool(addr, this._options);
                this._pools.put(addr, p);
                try {
                    String on = this.createObjectName(addr);
                    if (MBeanServerFactory.getMBeanServer().isRegistered(on)) {
                        MBeanServerFactory.getMBeanServer().unregisterMBean(on);
                        Bytes.LOGGER.log(Level.INFO, "multiple Mongo instances for same host, jmx numbers might be off");
                    }
                    MBeanServerFactory.getMBeanServer().registerMBean(p, on);
                }
                catch (JMException e) {
                    Bytes.LOGGER.log(Level.WARNING, "jmx registration error: " + e + " continuing...");
                }
                catch (AccessControlException e) {
                    Bytes.LOGGER.log(Level.WARNING, "jmx registration error: " + e + " continuing...");
                }
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Map<ServerAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                for (DBPortPool p : this._pools.values()) {
                    p.close();
                    try {
                        String on = this.createObjectName(p._addr);
                        if (!MBeanServerFactory.getMBeanServer().isRegistered(on)) continue;
                        MBeanServerFactory.getMBeanServer().unregisterMBean(on);
                    }
                    catch (JMException e) {
                        Bytes.LOGGER.log(Level.WARNING, "jmx de-registration error, continuing", e);
                    }
                }
            }
        }

        private String createObjectName(ServerAddress addr) {
            String name = "com.mongodb:type=ConnectionPool,host=" + addr.toString().replace(":", ",port=") + ",instance=" + this._serial;
            if (this._options.description != null) {
                name = name + ",description=" + this._options.description;
            }
            return name;
        }
    }
}

