/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DBObject;
import com.mongodb.DBRefBase;
import com.mongodb.util.BSONObjectSerializer;
import com.mongodb.util.Base64Codec;
import com.mongodb.util.JSON;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class BSONSerializerFactory {
    public static BSONObjectSerializer buildLegacyBSONSerializer() {
        BSONObjectSerializer serializer = new BSONObjectSerializer();
        serializer.addObjectSerializer(byte[].class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                buf.append("<Binary Data>");
            }
        });
        serializer.addObjectSerializer(Object[].class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                buf.append("[ ");
                for (int i = 0; i < Array.getLength(obj); ++i) {
                    if (i > 0) {
                        buf.append(" , ");
                    }
                    serializer.serialize(Array.get(obj, i), buf);
                }
                buf.append("]");
            }
        });
        serializer.addObjectSerializer(Binary.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                buf.append("<Binary Data>");
            }
        });
        serializer.addObjectSerializer(Boolean.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                buf.append(obj.toString());
            }
        });
        serializer.addObjectSerializer(BSONTimestamp.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                BSONTimestamp t = (BSONTimestamp)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$ts", (Object)t.getTime());
                temp.put("$inc", (Object)t.getInc());
                serializer.serialize(temp, buf);
            }
        });
        serializer.addObjectSerializer(byte[].class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                buf.append("<Binary Data>");
            }
        });
        serializer.addObjectSerializer(Code.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                Code c = (Code)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$code", (Object)c.getCode());
                serializer.serialize(temp, buf);
            }
        });
        serializer.addObjectSerializer(CodeWScope.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                CodeWScope c = (CodeWScope)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$code", (Object)c.getCode());
                temp.put("$scope", (Object)c.getScope());
                serializer.serialize(temp, buf);
            }
        });
        serializer.addObjectSerializer(Date.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                Date d = (Date)obj;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                serializer.serialize(new BasicDBObject("$date", format.format(d)), buf);
            }
        });
        serializer.addObjectSerializer(DBObject.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                boolean first = true;
                buf.append("{ ");
                DBObject dbo = (DBObject)obj;
                for (String name : dbo.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(" , ");
                    }
                    JSON.string(buf, name);
                    buf.append(" : ");
                    serializer.serialize(dbo.get(name), buf);
                }
                buf.append("}");
            }
        });
        serializer.addObjectSerializer(DBRefBase.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                DBRefBase ref = (DBRefBase)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$ref", (Object)ref.getRef());
                temp.put("$id", ref.getId());
                serializer.serialize(temp, buf);
            }
        });
        serializer.addObjectSerializer(Iterable.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                boolean first = true;
                buf.append("[ ");
                Iterator it = ((Iterable)obj).iterator();
                while (it.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(" , ");
                    }
                    serializer.serialize(it.next(), buf);
                }
                buf.append("]");
            }
        });
        serializer.addObjectSerializer(Map.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                boolean first = true;
                buf.append("{ ");
                Map m = (Map)obj;
                for (Map.Entry entry : m.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(" , ");
                    }
                    JSON.string(buf, entry.getKey().toString());
                    buf.append(" : ");
                    serializer.serialize(entry.getValue(), buf);
                }
                buf.append("}");
            }
        });
        serializer.addObjectSerializer(MaxKey.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                serializer.serialize(new BasicDBObject("$maxKey", (Object)1), buf);
            }
        });
        serializer.addObjectSerializer(MinKey.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                serializer.serialize(new BasicDBObject("$minKey", (Object)1), buf);
            }
        });
        serializer.addObjectSerializer(Number.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                buf.append(obj.toString());
            }
        });
        serializer.addObjectSerializer(ObjectId.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                serializer.serialize(new BasicDBObject("$oid", obj.toString()), buf);
            }
        });
        serializer.addObjectSerializer(Pattern.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                BasicDBObject externalForm = new BasicDBObject();
                externalForm.put("$regex", (Object)obj.toString());
                if (((Pattern)obj).flags() != 0) {
                    externalForm.put("$options", (Object)Bytes.regexFlags(((Pattern)obj).flags()));
                }
                serializer.serialize(externalForm, buf);
            }
        });
        serializer.addObjectSerializer(String.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                JSON.string(buf, (String)obj);
            }
        });
        serializer.addObjectSerializer(UUID.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                UUID uuid = (UUID)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$uuid", (Object)uuid.toString());
                serializer.serialize(temp, buf);
            }
        });
        return serializer;
    }

    public static BSONObjectSerializer buildStrictBSONSerializer() {
        BSONObjectSerializer serializer = BSONSerializerFactory.buildLegacyBSONSerializer();
        serializer.addObjectSerializer(Binary.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                Binary bin = (Binary)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$binary", (Object)new Base64Codec().encode(bin.getData()));
                temp.put("$type", (Object)bin.getType());
                serializer.serialize(temp, buf);
            }
        });
        serializer.addObjectSerializer(BSONTimestamp.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                BSONTimestamp t = (BSONTimestamp)obj;
                BasicDBObject temp = new BasicDBObject();
                temp.put("$t", (Object)t.getTime());
                temp.put("$i", (Object)t.getInc());
                BasicDBObject timestampObj = new BasicDBObject();
                timestampObj.put("$timestamp", (Object)temp);
                serializer.serialize(timestampObj, buf);
            }
        });
        serializer.addObjectSerializer(byte[].class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                BasicDBObject temp = new BasicDBObject();
                temp.put("$binary", (Object)new Base64Codec().encode((byte[])obj));
                temp.put("$type", (Object)0);
                serializer.serialize(temp, buf);
            }
        });
        serializer.addObjectSerializer(Date.class, new BSONObjectSerializer.ObjectSerializer(){

            public void serialize(Object obj, BSONObjectSerializer serializer, StringBuilder buf) {
                Date d = (Date)obj;
                serializer.serialize(new BasicDBObject("$date", (Object)d.getTime()), buf);
            }
        });
        return serializer;
    }
}

