/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.bson.BSONException;
import org.bson.io.Bits;
import org.bson.io.PoolOutputBuffer;

public class BSONInput {
    int _read;
    final InputStream _raw;
    private byte[] _random = new byte[1024];
    private byte[] _inputBuffer = new byte[1024];
    private PoolOutputBuffer _stringBuffer = new PoolOutputBuffer();
    protected int _pos;
    protected int _len;
    protected int _max = 4;
    static final String[] ONE_BYTE_STRINGS = new String[128];

    public BSONInput(InputStream in) {
        this._raw = in;
        this._read = 0;
        this._pos = 0;
        this._len = 0;
    }

    protected int _need(int num) throws IOException {
        if (this._len - this._pos >= num) {
            int ret = this._pos;
            this._pos += num;
            this._read += num;
            return ret;
        }
        if (num >= this._inputBuffer.length) {
            throw new IllegalArgumentException("you can't need that much");
        }
        int remaining = this._len - this._pos;
        if (this._pos > 0) {
            System.arraycopy(this._inputBuffer, this._pos, this._inputBuffer, 0, remaining);
            this._pos = 0;
            this._len = remaining;
        }
        int maxToRead = Math.min(this._max - this._read - remaining, this._inputBuffer.length - this._len);
        while (maxToRead > 0) {
            int x = this._raw.read(this._inputBuffer, this._len, maxToRead);
            if (x <= 0) {
                throw new IOException("unexpected EOF");
            }
            maxToRead -= x;
            this._len += x;
        }
        int ret = this._pos;
        this._pos += num;
        this._read += num;
        return ret;
    }

    public int readInt() throws IOException {
        return Bits.readInt(this._inputBuffer, this._need(4));
    }

    public int readIntBE() throws IOException {
        return Bits.readIntBE(this._inputBuffer, this._need(4));
    }

    public long readLong() throws IOException {
        return Bits.readLong(this._inputBuffer, this._need(8));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte read() throws IOException {
        if (this._pos < this._len) {
            ++this._read;
            return this._inputBuffer[this._pos++];
        }
        return this._inputBuffer[this._need(1)];
    }

    public void fill(byte[] b) throws IOException {
        this.fill(b, b.length);
    }

    public void fill(byte[] b, int len) throws IOException {
        int have = this._len - this._pos;
        int tocopy = Math.min(len, have);
        System.arraycopy(this._inputBuffer, this._pos, b, 0, tocopy);
        this._pos += tocopy;
        this._read += tocopy;
        len -= tocopy;
        int off = tocopy;
        while (len > 0) {
            int x = this._raw.read(b, off, len);
            if (x <= 0) {
                throw new IOException("unexpected EOF");
            }
            this._read += x;
            off += x;
            len -= x;
        }
    }

    protected boolean _isAscii(byte b) {
        return b >= 0 && b <= 127;
    }

    public String readCStr() throws IOException {
        byte b;
        boolean isAscii = true;
        this._random[0] = this.read();
        if (this._random[0] == 0) {
            return "";
        }
        this._random[1] = this.read();
        if (this._random[1] == 0) {
            String out = ONE_BYTE_STRINGS[this._random[0]];
            if (out != null) {
                return out;
            }
            return new String(this._random, 0, 1, "UTF-8");
        }
        this._stringBuffer.reset();
        this._stringBuffer.write(this._random[0]);
        this._stringBuffer.write(this._random[1]);
        boolean bl = isAscii = this._isAscii(this._random[0]) && this._isAscii(this._random[1]);
        while ((b = this.read()) != 0) {
            this._stringBuffer.write(b);
            isAscii = isAscii && this._isAscii(b);
        }
        String out = null;
        if (isAscii) {
            out = this._stringBuffer.asAscii();
        } else {
            try {
                out = this._stringBuffer.asString("UTF-8");
            }
            catch (UnsupportedOperationException e) {
                throw new BSONException("impossible", e);
            }
        }
        this._stringBuffer.reset();
        return out;
    }

    public String readUTF8String() throws IOException {
        int size = this.readInt();
        if (size <= 0 || size > 0x2000000) {
            throw new BSONException("bad string size: " + size);
        }
        if (size < this._inputBuffer.length / 2) {
            if (size == 1) {
                this.read();
                return "";
            }
            return new String(this._inputBuffer, this._need(size), size - 1, "UTF-8");
        }
        byte[] b = size < this._random.length ? this._random : new byte[size];
        this.fill(b, size);
        try {
            return new String(b, 0, size - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new BSONException("impossible", uee);
        }
    }

    public int numRead() {
        return this._read;
    }

    public int getPos() {
        return this._pos;
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int _max) {
        this._max = _max;
    }

    static void _fillRange(byte min, byte max) {
        while (min < max) {
            String s = "";
            BSONInput.ONE_BYTE_STRINGS[min] = s = s + (char)min;
            min = (byte)(min + 1);
        }
    }

    static {
        BSONInput._fillRange((byte)48, (byte)57);
        BSONInput._fillRange((byte)97, (byte)122);
        BSONInput._fillRange((byte)65, (byte)90);
    }
}

