/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.OutMessage;
import com.mongodb.ReadPreference;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTCPConnector
implements DBConnector {
    static Logger _logger = Logger.getLogger(Bytes.LOGGER.getName() + ".tcp");
    static Logger _createLogger = Logger.getLogger(_logger.getName() + ".connect");
    private Mongo _mongo;
    private DBPortPool _masterPortPool;
    private DBPortPool.Holder _portHolder;
    private final List<ServerAddress> _allHosts;
    private ReplicaSetStatus _rsStatus;
    private boolean _closed = false;
    private int maxBsonObjectSize = 0;
    private ThreadLocal<MyPort> _myPort = new ThreadLocal<MyPort>(){

        @Override
        protected MyPort initialValue() {
            return new MyPort();
        }
    };

    public DBTCPConnector(Mongo m, ServerAddress addr) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(addr);
        _createLogger.info(addr.toString());
        this._set(addr);
        this._allHosts = null;
        this._rsStatus = null;
    }

    public DBTCPConnector(Mongo m, ServerAddress ... all) throws MongoException {
        this(m, Arrays.asList(all));
    }

    public DBTCPConnector(Mongo m, List<ServerAddress> all) throws MongoException {
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(all);
        this._allHosts = new ArrayList<ServerAddress>(all);
        this._rsStatus = new ReplicaSetStatus(m, this._allHosts);
        _createLogger.info(all + " -> " + this.getAddress());
    }

    public void start() {
        if (this._rsStatus != null) {
            this._rsStatus.start();
        }
    }

    private static ServerAddress _checkAddress(ServerAddress addr) {
        if (addr == null) {
            throw new NullPointerException("address can't be null");
        }
        return addr;
    }

    private static ServerAddress _checkAddress(List<ServerAddress> addrs) {
        if (addrs == null) {
            throw new NullPointerException("addresses can't be null");
        }
        if (addrs.size() == 0) {
            throw new IllegalArgumentException("need to specify at least 1 address");
        }
        return addrs.get(0);
    }

    @Override
    public void requestStart() {
        this._myPort.get().requestStart();
    }

    @Override
    public void requestDone() {
        this._myPort.get().requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._myPort.get().requestEnsureConnection();
    }

    void _checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("this Mongo has been closed");
        }
    }

    WriteResult _checkWriteError(DB db, MyPort mp, DBPort port, WriteConcern concern) throws MongoException, IOException {
        CommandResult e = null;
        e = port.runCommand(db, (DBObject)concern.getCommand());
        if (!e.hasErr()) {
            return new WriteResult(e, concern);
        }
        e.throwOnError();
        return null;
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern) throws MongoException {
        return this.say(db, m, concern, null);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern, ServerAddress hostNeeded) throws MongoException {
        this._checkClosed();
        this.checkMaster(false, true);
        MyPort mp = this._myPort.get();
        DBPort port = mp.get(true, ReadPreference.PRIMARY, hostNeeded);
        try {
            port.checkAuth(db);
            port.say(m);
            if (concern.callGetLastError()) {
                WriteResult writeResult = this._checkWriteError(db, mp, port, concern);
                return writeResult;
            }
            WriteResult writeResult = new WriteResult(db, port, concern);
            return writeResult;
        }
        catch (IOException ioe) {
            mp.error(port, ioe);
            this._error(ioe, false);
            if (concern.raiseNetworkErrors()) {
                throw new MongoException.Network("can't say something", ioe);
            }
            CommandResult res = new CommandResult(port.serverAddress());
            res.put("ok", (Object)false);
            res.put("$err", (Object)"NETWORK ERROR");
            WriteResult writeResult = new WriteResult(res, concern);
            return writeResult;
        }
        catch (MongoException me) {
            throw me;
        }
        catch (RuntimeException re) {
            mp.error(port, re);
            throw re;
        }
        finally {
            mp.done(port);
            m.doneWithMessage();
        }
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, DBDecoder decoder) throws MongoException {
        return this.call(db, coll, m, hostNeeded, 2, null, decoder);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries) throws MongoException {
        return this.call(db, coll, m, hostNeeded, retries, null, null);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries, ReadPreference readPref, DBDecoder decoder) throws MongoException {
        if (readPref == ReadPreference.PRIMARY && m.hasOption(4)) {
            readPref = ReadPreference.SECONDARY;
        }
        boolean secondaryOk = readPref != ReadPreference.PRIMARY;
        this._checkClosed();
        this.checkMaster(false, !secondaryOk);
        MyPort mp = this._myPort.get();
        DBPort port = mp.get(false, readPref, hostNeeded);
        Response res = null;
        boolean retry = false;
        try {
            port.checkAuth(db);
            res = port.call(m, coll, readPref, decoder);
            if (res._responseTo != m.getId()) {
                throw new MongoException("ids don't match");
            }
        }
        catch (IOException ioe) {
            mp.error(port, ioe);
            boolean bl = retry = retries > 0 && !coll._name.equals("$cmd") && !(ioe instanceof SocketTimeoutException) && this._error(ioe, secondaryOk);
            if (!retry) {
                throw new MongoException.Network("can't call something : " + port.host() + "/" + db, ioe);
            }
        }
        catch (RuntimeException re) {
            mp.error(port, re);
            throw re;
        }
        finally {
            mp.done(port);
        }
        if (retry) {
            return this.call(db, coll, m, hostNeeded, retries - 1, readPref, decoder);
        }
        ServerError err = res.getError();
        if (err != null && err.isNotMasterError()) {
            this.checkMaster(true, true);
            if (retries <= 0) {
                throw new MongoException("not talking to master and retries used up");
            }
            return this.call(db, coll, m, hostNeeded, retries - 1, readPref, decoder);
        }
        m.doneWithMessage();
        return res;
    }

    public ServerAddress getAddress() {
        DBPortPool pool = this._masterPortPool;
        return pool != null ? pool.getServerAddress() : null;
    }

    public List<ServerAddress> getAllAddress() {
        return this._allHosts;
    }

    public List<ServerAddress> getServerAddressList() {
        if (this._rsStatus != null) {
            return this._rsStatus.getServerAddressList();
        }
        ServerAddress master = this.getAddress();
        if (master != null) {
            ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
            list.add(master);
            return list;
        }
        return null;
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        return this._rsStatus;
    }

    public String getConnectPoint() {
        ServerAddress master = this.getAddress();
        return master != null ? master.toString() : null;
    }

    boolean _error(Throwable t, boolean secondaryOk) throws MongoException {
        if (this._rsStatus == null) {
            return false;
        }
        if (this._rsStatus.hasServerUp()) {
            this.checkMaster(true, !secondaryOk);
        }
        return this._rsStatus.hasServerUp();
    }

    void checkMaster(boolean force, boolean failIfNoMaster) throws MongoException {
        if (this._rsStatus != null) {
            if (this._masterPortPool == null || force) {
                ReplicaSetStatus.Node n = this._rsStatus.ensureMaster();
                if (n == null) {
                    if (failIfNoMaster) {
                        throw new MongoException("can't find a master");
                    }
                } else {
                    this._set(n._addr);
                    this.maxBsonObjectSize = this._rsStatus.getMaxBsonObjectSize();
                }
            }
        } else if (this.maxBsonObjectSize == 0) {
            this.maxBsonObjectSize = this.fetchMaxBsonObjectSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int fetchMaxBsonObjectSize() {
        if (this._masterPortPool == null) {
            return 0;
        }
        DBPort port = this._masterPortPool.get();
        try {
            CommandResult res = port.runCommand(this._mongo.getDB("admin"), (DBObject)new BasicDBObject("isMaster", (Object)1));
            this.maxBsonObjectSize = res.containsField("maxBsonObjectSize") ? (Integer)res.get("maxBsonObjectSize") : 0x400000;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception determining maxBSON size using" + this.maxBsonObjectSize, e);
        }
        finally {
            port.getPool().done(port);
        }
        return this.maxBsonObjectSize;
    }

    void testMaster() throws MongoException {
        DBPort p = null;
        try {
            p = this._masterPortPool.get();
            p.runCommand(this._mongo.getDB("admin"), (DBObject)new BasicDBObject("nonce", (Object)1));
        }
        catch (IOException ioe) {
            throw new MongoException.Network(ioe.getMessage(), ioe);
        }
        finally {
            this._masterPortPool.done(p);
        }
    }

    private boolean _set(ServerAddress addr) {
        DBPortPool newPool = this._portHolder.get(addr);
        if (newPool == this._masterPortPool) {
            return false;
        }
        if (_logger.isLoggable(Level.WARNING) && this._masterPortPool != null) {
            _logger.log(Level.WARNING, "Master switching from " + this._masterPortPool.getServerAddress() + " to " + addr);
        }
        this._masterPortPool = newPool;
        return true;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder("DBTCPConnector: ");
        if (this._rsStatus != null) {
            buf.append("replica set : ").append(this._allHosts);
        } else {
            ServerAddress master = this.getAddress();
            buf.append(master).append(" ").append(master != null ? master._addr : null);
        }
        return buf.toString();
    }

    public void close() {
        this._closed = true;
        if (this._portHolder != null) {
            this._portHolder.close();
            this._portHolder = null;
        }
        if (this._rsStatus != null) {
            this._rsStatus.close();
            this._rsStatus = null;
        }
        this._myPort.remove();
    }

    public void updatePortPool(ServerAddress addr) {
        this._portHolder._pools.remove(addr);
    }

    public DBPortPool getDBPortPool(ServerAddress addr) {
        return this._portHolder.get(addr);
    }

    @Override
    public boolean isOpen() {
        return !this._closed;
    }

    public int getMaxBsonObjectSize() {
        return this.maxBsonObjectSize;
    }

    class MyPort {
        DBPort _requestPort;
        boolean _inRequest;

        MyPort() {
        }

        DBPort get(boolean keep, ReadPreference readPref, ServerAddress hostNeeded) {
            if (hostNeeded != null) {
                return DBTCPConnector.this._portHolder.get(hostNeeded).get();
            }
            if (this._requestPort != null) {
                if (this._requestPort.getPool() == DBTCPConnector.this._masterPortPool || !keep) {
                    return this._requestPort;
                }
                this._requestPort.getPool().done(this._requestPort);
                this._requestPort = null;
            }
            if (readPref != ReadPreference.PRIMARY && DBTCPConnector.this._rsStatus != null) {
                if (readPref == ReadPreference.SECONDARY) {
                    ServerAddress slave = DBTCPConnector.this._rsStatus.getASecondary();
                    if (slave != null) {
                        return DBTCPConnector.this._portHolder.get(slave).get();
                    }
                } else if (readPref instanceof ReadPreference.TaggedReadPreference) {
                    ServerAddress secondary = DBTCPConnector.this._rsStatus.getASecondary(((ReadPreference.TaggedReadPreference)readPref).getTags());
                    if (secondary != null) {
                        return DBTCPConnector.this._portHolder.get(secondary).get();
                    }
                    throw new MongoException("Could not find any valid secondaries with the supplied tags ('" + ((ReadPreference.TaggedReadPreference)readPref).getTags() + "'");
                }
            }
            if (DBTCPConnector.this._masterPortPool == null) {
                throw new MongoException("Rare case where master=null, probably all servers are down");
            }
            DBPort p = DBTCPConnector.this._masterPortPool.get();
            if (keep && this._inRequest) {
                this._requestPort = p;
            }
            return p;
        }

        void done(DBPort p) {
            if (p != this._requestPort) {
                p.getPool().done(p);
            }
        }

        void error(DBPort p, Exception e) {
            p.close();
            this._requestPort = null;
            p.getPool().gotError(e);
        }

        void requestEnsureConnection() {
            if (!this._inRequest) {
                return;
            }
            if (this._requestPort != null) {
                return;
            }
            this._requestPort = DBTCPConnector.this._masterPortPool.get();
        }

        void requestStart() {
            this._inRequest = true;
        }

        void requestDone() {
            if (this._requestPort != null) {
                this._requestPort.getPool().done(this._requestPort);
            }
            this._requestPort = null;
            this._inRequest = false;
        }
    }
}

