/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterType;
import com.mongodb.ServerAddress;
import com.mongodb.ServerConnectionState;
import com.mongodb.ServerType;
import com.mongodb.ServerVersion;
import com.mongodb.TagSet;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.util.Assertions;
import org.bson.util.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class ServerDescription {
    static final int MIN_DRIVER_WIRE_VERSION = 0;
    static final int MAX_DRIVER_WIRE_VERSION = 3;
    private static final int DEFAULT_MAX_DOCUMENT_SIZE = 0x1000000;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_WRITE_BATCH_SIZE = 512;
    private final ServerAddress address;
    private final ServerType type;
    private final Set<String> hosts;
    private final Set<String> passives;
    private final Set<String> arbiters;
    private final String primary;
    private final int maxDocumentSize;
    private final int maxWriteBatchSize;
    private final int maxMessageSize;
    private final TagSet tagSet;
    private final String setName;
    private final long averageLatencyNanos;
    private final boolean ok;
    private final ServerConnectionState state;
    private final ServerVersion version;
    private final int minWireVersion;
    private final int maxWireVersion;
    private Throwable exception;

    public boolean isCompatibleWithDriver() {
        if (!this.ok) {
            return true;
        }
        if (this.minWireVersion > 3) {
            return false;
        }
        return this.maxWireVersion >= 0;
    }

    public static int getDefaultMaxDocumentSize() {
        return 0x1000000;
    }

    public static int getDefaultMaxMessageSize() {
        return 0x2000000;
    }

    public static int getDefaultMinWireVersion() {
        return 0;
    }

    public static int getDefaultMaxWireVersion() {
        return 0;
    }

    public static int getDefaultMaxWriteBatchSize() {
        return 512;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public boolean isReplicaSetMember() {
        return this.type == ServerType.ReplicaSetPrimary || this.type == ServerType.ReplicaSetSecondary || this.type == ServerType.ReplicaSetArbiter || this.type == ServerType.ReplicaSetOther || this.type == ServerType.ReplicaSetGhost;
    }

    public boolean isShardRouter() {
        return this.type == ServerType.ShardRouter;
    }

    public boolean isStandAlone() {
        return this.type == ServerType.StandAlone;
    }

    public boolean isPrimary() {
        return this.ok && (this.type == ServerType.ReplicaSetPrimary || this.type == ServerType.ShardRouter || this.type == ServerType.StandAlone);
    }

    public boolean isSecondary() {
        return this.ok && (this.type == ServerType.ReplicaSetSecondary || this.type == ServerType.ShardRouter || this.type == ServerType.StandAlone);
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public Set<String> getPassives() {
        return this.passives;
    }

    public Set<String> getArbiters() {
        return this.arbiters;
    }

    public String getPrimary() {
        return this.primary;
    }

    public int getMaxDocumentSize() {
        return this.maxDocumentSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    public TagSet getTagSet() {
        return this.tagSet;
    }

    public int getMinWireVersion() {
        return this.minWireVersion;
    }

    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    public boolean hasTags(TagSet desiredTags) {
        if (!this.ok) {
            return false;
        }
        if (this.type == ServerType.StandAlone || this.type == ServerType.ShardRouter) {
            return true;
        }
        return this.tagSet.containsAll(desiredTags);
    }

    public String getSetName() {
        return this.setName;
    }

    public boolean isOk() {
        return this.ok;
    }

    public ServerConnectionState getState() {
        return this.state;
    }

    public ServerType getType() {
        return this.type;
    }

    public ClusterType getClusterType() {
        return this.type.getClusterType();
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    public long getAverageLatencyNanos() {
        return this.averageLatencyNanos;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean equals(Object o) {
        String thatExceptionMessage;
        Class<?> thatExceptionClass;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerDescription that = (ServerDescription)o;
        if (this.maxDocumentSize != that.maxDocumentSize) {
            return false;
        }
        if (this.maxMessageSize != that.maxMessageSize) {
            return false;
        }
        if (this.maxWriteBatchSize != that.maxWriteBatchSize) {
            return false;
        }
        if (this.ok != that.ok) {
            return false;
        }
        if (!this.address.equals(that.address)) {
            return false;
        }
        if (!this.arbiters.equals(that.arbiters)) {
            return false;
        }
        if (!this.hosts.equals(that.hosts)) {
            return false;
        }
        if (!this.passives.equals(that.passives)) {
            return false;
        }
        if (this.primary != null ? !this.primary.equals(that.primary) : that.primary != null) {
            return false;
        }
        if (this.setName != null ? !this.setName.equals(that.setName) : that.setName != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.tagSet.equals(that.tagSet)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (this.minWireVersion != that.minWireVersion) {
            return false;
        }
        if (this.maxWireVersion != that.maxWireVersion) {
            return false;
        }
        Class<?> thisExceptionClass = this.exception != null ? this.exception.getClass() : null;
        Class<?> clazz = thatExceptionClass = that.exception != null ? that.exception.getClass() : null;
        if (thisExceptionClass != null ? !thisExceptionClass.equals(thatExceptionClass) : thatExceptionClass != null) {
            return false;
        }
        String thisExceptionMessage = this.exception != null ? this.exception.getMessage() : null;
        String string = thatExceptionMessage = that.exception != null ? that.exception.getMessage() : null;
        return !(thisExceptionMessage != null ? !thisExceptionMessage.equals(thatExceptionMessage) : thatExceptionMessage != null);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.hosts.hashCode();
        result = 31 * result + this.passives.hashCode();
        result = 31 * result + this.arbiters.hashCode();
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        result = 31 * result + this.maxDocumentSize;
        result = 31 * result + this.maxMessageSize;
        result = 31 * result + this.maxWriteBatchSize;
        result = 31 * result + this.tagSet.hashCode();
        result = 31 * result + (this.setName != null ? this.setName.hashCode() : 0);
        result = 31 * result + (this.ok ? 1 : 0);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.minWireVersion;
        result = 31 * result + this.maxWireVersion;
        result = 31 * result + (this.exception == null ? 0 : this.exception.getClass().hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.getMessage().hashCode());
        return result;
    }

    public String toString() {
        return "ServerDescription{address=" + this.address + ", type=" + (Object)((Object)this.type) + ", hosts=" + this.hosts + ", passives=" + this.passives + ", arbiters=" + this.arbiters + ", primary='" + this.primary + '\'' + ", maxDocumentSize=" + this.maxDocumentSize + ", maxMessageSize=" + this.maxMessageSize + ", maxWriteBatchSize=" + this.maxWriteBatchSize + ", tagSet=" + this.tagSet + ", setName='" + this.setName + '\'' + ", averageLatencyNanos=" + this.averageLatencyNanos + ", ok=" + this.ok + ", state=" + (Object)((Object)this.state) + ", version=" + this.version + ", minWireVersion=" + this.minWireVersion + ", maxWireVersion=" + this.maxWireVersion + '}';
    }

    public String getShortDescription() {
        return "{address=" + this.address + ", type=" + (Object)((Object)this.type) + (!this.tagSet.iterator().hasNext() ? "" : ", " + this.tagSet) + (this.state == ServerConnectionState.Connected ? ", averageLatency=" + this.getAverageLatencyFormattedInMilliseconds() + " ms" : "") + ", state=" + (Object)((Object)this.state) + (this.exception == null ? "" : ", exception=" + this.translateExceptionToString()) + '}';
    }

    private String translateExceptionToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.exception);
        builder.append("}");
        for (Throwable cur = this.exception.getCause(); cur != null; cur = cur.getCause()) {
            builder.append(", caused by ");
            builder.append("{");
            builder.append(cur);
            builder.append("}");
        }
        return builder.toString();
    }

    private String getAverageLatencyFormattedInMilliseconds() {
        return new DecimalFormat("#0.0").format((double)this.averageLatencyNanos / 1000.0 / 1000.0);
    }

    ServerDescription(Builder builder) {
        this.address = Assertions.notNull("address", builder.address);
        this.type = Assertions.notNull("type", builder.type);
        this.state = Assertions.notNull("state", builder.state);
        this.version = Assertions.notNull("version", builder.version);
        this.hosts = builder.hosts;
        this.passives = builder.passives;
        this.arbiters = builder.arbiters;
        this.primary = builder.primary;
        this.maxDocumentSize = builder.maxDocumentSize;
        this.maxMessageSize = builder.maxMessageSize;
        this.maxWriteBatchSize = builder.maxWriteBatchSize;
        this.tagSet = builder.tags;
        this.setName = builder.setName;
        this.averageLatencyNanos = builder.averageLatency;
        this.ok = builder.ok;
        this.minWireVersion = builder.minWireVersion;
        this.maxWireVersion = builder.maxWireVersion;
        this.exception = builder.exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Builder {
        private ServerAddress address;
        private ServerType type = ServerType.Unknown;
        private Set<String> hosts = Collections.emptySet();
        private Set<String> passives = Collections.emptySet();
        private Set<String> arbiters = Collections.emptySet();
        private String primary;
        private int maxDocumentSize = 0x1000000;
        private int maxMessageSize = 0x2000000;
        private int maxWriteBatchSize = 512;
        private TagSet tags = new TagSet();
        private String setName;
        private long averageLatency;
        private boolean ok;
        private ServerConnectionState state;
        private ServerVersion version = new ServerVersion();
        private int minWireVersion = 0;
        private int maxWireVersion = 0;
        private Throwable exception;

        Builder() {
        }

        public Builder address(ServerAddress address) {
            this.address = address;
            return this;
        }

        public Builder type(ServerType type) {
            this.type = Assertions.notNull("type", type);
            return this;
        }

        public Builder hosts(Set<String> hosts) {
            this.hosts = hosts == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(hosts));
            return this;
        }

        public Builder passives(Set<String> passives) {
            this.passives = passives == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(passives));
            return this;
        }

        public Builder arbiters(Set<String> arbiters) {
            this.arbiters = arbiters == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(arbiters));
            return this;
        }

        public Builder primary(String primary) {
            this.primary = primary;
            return this;
        }

        public Builder maxDocumentSize(int maxBSONObjectSize) {
            this.maxDocumentSize = maxBSONObjectSize;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public Builder maxWriteBatchSize(int maxWriteBatchSize) {
            this.maxWriteBatchSize = maxWriteBatchSize;
            return this;
        }

        public Builder tagSet(TagSet tags) {
            this.tags = tags == null ? new TagSet() : tags;
            return this;
        }

        public Builder averageLatency(long averageLatency, TimeUnit timeUnit) {
            this.averageLatency = timeUnit.toNanos(averageLatency);
            return this;
        }

        public Builder setName(String setName) {
            this.setName = setName;
            return this;
        }

        public Builder ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder state(ServerConnectionState state) {
            this.state = state;
            return this;
        }

        public Builder version(ServerVersion version) {
            Assertions.notNull("version", version);
            this.version = version;
            return this;
        }

        public Builder minWireVersion(int minWireVersion) {
            this.minWireVersion = minWireVersion;
            return this;
        }

        public Builder maxWireVersion(int maxWireVersion) {
            this.maxWireVersion = maxWireVersion;
            return this;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ServerDescription build() {
            return new ServerDescription(this);
        }
    }
}

