/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterDescription;
import com.mongodb.ClusterType;
import com.mongodb.ServerAddress;
import com.mongodb.ServerDescription;
import com.mongodb.ServerSelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StickyHAShardedClusterServerSelector
implements ServerSelector {
    private ServerAddress stickyMongos;
    private Set<ServerAddress> consideredServers = new HashSet<ServerAddress>();

    StickyHAShardedClusterServerSelector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerDescription> choose(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() != ClusterConnectionMode.Multiple || clusterDescription.getType() != ClusterType.Sharded) {
            throw new IllegalArgumentException("This is not a sharded cluster with multiple mongos servers");
        }
        Set<ServerAddress> okServers = this.getOkServers(clusterDescription);
        StickyHAShardedClusterServerSelector stickyHAShardedClusterServerSelector = this;
        synchronized (stickyHAShardedClusterServerSelector) {
            if (!this.consideredServers.containsAll(okServers) || !okServers.contains(this.stickyMongos)) {
                if (this.stickyMongos != null && !okServers.contains(this.stickyMongos)) {
                    this.stickyMongos = null;
                    this.consideredServers.clear();
                }
                ServerDescription fastestServer = null;
                for (ServerDescription cur : clusterDescription.getAny()) {
                    if (fastestServer != null && cur.getAveragePingTimeNanos() >= fastestServer.getAveragePingTimeNanos()) continue;
                    fastestServer = cur;
                }
                if (fastestServer != null) {
                    this.stickyMongos = fastestServer.getAddress();
                    this.consideredServers.addAll(okServers);
                }
            }
            if (this.stickyMongos == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(clusterDescription.getByServerAddress(this.stickyMongos));
        }
    }

    public String toString() {
        return "StickyHAShardedClusterServerSelector{stickyMongos=" + this.stickyMongos + '}';
    }

    private Set<ServerAddress> getOkServers(ClusterDescription clusterDescription) {
        HashSet<ServerAddress> okServers = new HashSet<ServerAddress>();
        for (ServerDescription cur : clusterDescription.getAny()) {
            okServers.add(cur.getAddress());
        }
        return okServers;
    }
}

