/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ConnectionEvent;
import com.mongodb.ConnectionPoolEvent;
import com.mongodb.ConnectionPoolListener;
import com.mongodb.ConnectionPoolOpenedEvent;
import com.mongodb.ConnectionPoolStatistics;
import com.mongodb.ConnectionPoolStatisticsMBean;
import com.mongodb.ConnectionPoolWaitQueueEvent;
import com.mongodb.ServerAddress;
import com.mongodb.util.management.MBeanServerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class JMXConnectionPoolListener
implements ConnectionPoolListener {
    private final ConcurrentMap<ClusterIdServerAddressPair, ConnectionPoolStatistics> map = new ConcurrentHashMap<ClusterIdServerAddressPair, ConnectionPoolStatistics>();

    JMXConnectionPoolListener() {
    }

    public String getMBeanObjectName(String clusterId, ServerAddress serverAddress) {
        String adjustedClusterId = clusterId.replace(":", "%3A");
        String adjustedHost = serverAddress.getHost().replace(":", "%3A");
        return String.format("org.mongodb.driver:type=ConnectionPool,clusterId=%s,host=%s,port=%s", adjustedClusterId, adjustedHost, serverAddress.getPort());
    }

    public ConnectionPoolStatisticsMBean getMBean(String clusterId, ServerAddress serverAddress) {
        return this.getStatistics(clusterId, serverAddress);
    }

    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        ConnectionPoolStatistics statistics = new ConnectionPoolStatistics(event);
        this.map.put(new ClusterIdServerAddressPair(event.getClusterId(), event.getServerAddress()), statistics);
        MBeanServerFactory.getMBeanServer().registerMBean(statistics, this.getMBeanObjectName(event.getClusterId(), event.getServerAddress()));
    }

    public void connectionPoolClosed(ConnectionPoolEvent event) {
        this.map.remove(new ClusterIdServerAddressPair(event.getClusterId(), event.getServerAddress()));
        MBeanServerFactory.getMBeanServer().unregisterMBean(this.getMBeanObjectName(event.getClusterId(), event.getServerAddress()));
    }

    public void connectionCheckedOut(ConnectionEvent event) {
        this.getStatistics(event).connectionCheckedOut(event);
    }

    public void connectionCheckedIn(ConnectionEvent event) {
        this.getStatistics(event).connectionCheckedIn(event);
    }

    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        this.getStatistics(event).waitQueueEntered(event);
    }

    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        this.getStatistics(event).waitQueueExited(event);
    }

    public void connectionAdded(ConnectionEvent event) {
        this.getStatistics(event).connectionAdded(event);
    }

    public void connectionRemoved(ConnectionEvent event) {
        this.getStatistics(event).connectionRemoved(event);
    }

    private ConnectionPoolStatistics getStatistics(ConnectionEvent event) {
        return this.getStatistics(event.getClusterId(), event.getServerAddress());
    }

    private ConnectionPoolListener getStatistics(ConnectionPoolEvent event) {
        return this.getStatistics(event.getClusterId(), event.getServerAddress());
    }

    private ConnectionPoolStatistics getStatistics(String clusterId, ServerAddress serverAddress) {
        return (ConnectionPoolStatistics)this.map.get(new ClusterIdServerAddressPair(clusterId, serverAddress));
    }

    private static final class ClusterIdServerAddressPair {
        private final String clusterId;
        private final ServerAddress serverAddress;

        private ClusterIdServerAddressPair(String clusterId, ServerAddress serverAddress) {
            this.clusterId = clusterId;
            this.serverAddress = serverAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterIdServerAddressPair that = (ClusterIdServerAddressPair)o;
            if (!this.clusterId.equals(that.clusterId)) {
                return false;
            }
            return this.serverAddress.equals(that.serverAddress);
        }

        public int hashCode() {
            int result = this.clusterId.hashCode();
            result = 31 * result + this.serverAddress.hashCode();
            return result;
        }
    }
}

