/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.io.IOException;
import org.bson.BSONObject;

public class MongoException
extends RuntimeException {
    final int _code;

    public MongoException(String msg) {
        super(msg);
        this._code = -3;
    }

    public MongoException(int code, String msg) {
        super(msg);
        this._code = code;
    }

    public MongoException(String msg, Throwable t) {
        super(msg, MongoException._massage(t));
        this._code = -4;
    }

    public MongoException(int code, String msg, Throwable t) {
        super(msg, MongoException._massage(t));
        this._code = code;
    }

    public MongoException(BSONObject o) {
        this(MongoException._getCode(o), MongoException._getMsg(o));
    }

    static int _getCode(BSONObject o) {
        Object c = o.get("code");
        if (c == null) {
            c = o.get("$code");
        }
        if (c == null) {
            return -5;
        }
        return ((Number)c).intValue();
    }

    static String _getMsg(BSONObject o) {
        Object e = o.get("$err");
        if (e == null) {
            e = o.get("err");
        }
        if (e == null) {
            return "UNKNOWN";
        }
        return e.toString();
    }

    static Throwable _massage(Throwable t) {
        if (t instanceof Network) {
            return ((Network)t)._ioe;
        }
        return t;
    }

    public int getCode() {
        return this._code;
    }

    public static class DuplicateKey
    extends MongoException {
        DuplicateKey(int code, String msg) {
            super(code, msg);
        }
    }

    public static class Network
    extends MongoException {
        final IOException _ioe;

        Network(String msg, IOException ioe) {
            super(-2, msg, ioe);
            this._ioe = ioe;
        }

        Network(IOException ioe) {
            super(ioe.toString(), ioe);
            this._ioe = ioe;
        }
    }
}

