/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.Bytes;
import com.mongodb.DBObject;
import com.mongodb.DBRefBase;
import com.mongodb.ObjectId;
import com.mongodb.util.JSONParser;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.regex.Pattern;

public class JSON {
    public static String serialize(Object o) {
        StringBuilder buf = new StringBuilder();
        JSON.serialize(o, buf);
        return buf.toString();
    }

    static void string(StringBuilder a, String s) {
        a.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                a.append("\\\\");
                continue;
            }
            if (c == '\"') {
                a.append("\\\"");
                continue;
            }
            if (c == '\n') {
                a.append("\\n");
                continue;
            }
            if (c == '\r') {
                a.append("\\r");
                continue;
            }
            if (c == '\t') {
                a.append("\\t");
                continue;
            }
            if (c == '\b') {
                a.append("\\b");
                continue;
            }
            if (c < ' ') continue;
            a.append(c);
        }
        a.append("\"");
    }

    public static void serialize(Object o, StringBuilder buf) {
        if ((o = Bytes.applyEncodingHooks(o)) == null) {
            buf.append(" null ");
            return;
        }
        if (o instanceof Number) {
            buf.append(o);
            return;
        }
        if (o instanceof String) {
            JSON.string(buf, o.toString());
            return;
        }
        if (o instanceof Collection) {
            boolean first = true;
            buf.append("[ ");
            for (Object n : (Collection)o) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.serialize(n, buf);
            }
            buf.append("]");
            return;
        }
        if (o instanceof ObjectId) {
            JSON.string(buf, o.toString());
            return;
        }
        if (o instanceof DBObject) {
            boolean first = true;
            buf.append("{ ");
            DBObject dbo = (DBObject)o;
            for (String name : dbo.keySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.string(buf, name);
                buf.append(" : ");
                JSON.serialize(dbo.get(name), buf);
            }
            buf.append("}");
            return;
        }
        if (o instanceof Map) {
            boolean first = true;
            buf.append("{ ");
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.string(buf, entry.getKey().toString());
                buf.append(" : ");
                JSON.serialize(entry.getValue(), buf);
            }
            buf.append("}");
            return;
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            buf.append('\"').append(format.format(d)).append('\"');
            return;
        }
        if (o instanceof Boolean || o instanceof DBRefBase) {
            buf.append(o);
            return;
        }
        if (o instanceof byte[]) {
            buf.append("<Binary Data>");
            return;
        }
        if (o instanceof Pattern) {
            buf.append("/").append(o.toString()).append("/").append(Bytes.patternFlags(((Pattern)o).flags()));
            return;
        }
        if (o.getClass().isArray()) {
            Object[] arr = (Object[])o;
            buf.append("[ ");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    buf.append(" , ");
                }
                JSON.serialize(arr[i], buf);
            }
            buf.append("]");
            return;
        }
        throw new RuntimeException("json can't serialize type : " + o.getClass());
    }

    public static Object parse(String s) {
        if (s == null || (s = s.trim()).equals("")) {
            return null;
        }
        JSONParser p = new JSONParser(s);
        return p.parse();
    }
}

