/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSONParseException;
import java.util.ArrayList;
import java.util.List;

class JSONParser {
    String s;
    int pos = 0;

    public JSONParser(String s) {
        this.s = s;
    }

    public Object parse() {
        Object value = null;
        char current = this.get();
        switch (current) {
            case 'n': {
                this.read('n');
                this.read('u');
                this.read('l');
                this.read('l');
                break;
            }
            case 't': {
                this.read('t');
                this.read('r');
                this.read('u');
                this.read('e');
                value = true;
                break;
            }
            case 'f': {
                this.read('f');
                this.read('a');
                this.read('l');
                this.read('s');
                this.read('e');
                value = false;
                break;
            }
            case '\"': 
            case '\'': {
                value = this.parseString();
                break;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                value = this.parseNumber();
                break;
            }
            case '[': {
                value = this.parseArray();
                break;
            }
            case '{': {
                value = this.parseObject();
                break;
            }
            default: {
                throw new JSONParseException(this.s, this.pos);
            }
        }
        return value;
    }

    public DBObject parseObject() {
        BasicDBObject obj = new BasicDBObject();
        this.read('{');
        char current = this.get();
        while (this.get() != '}') {
            String key = this.parseString();
            this.read(':');
            Object value = this.parse();
            obj.put(key, value);
            current = this.get();
            if (current != ',') break;
            this.read(',');
        }
        this.read('}');
        return obj;
    }

    public void read(char ch) {
        if (!this.check(ch)) {
            throw new JSONParseException(this.s, this.pos);
        }
        ++this.pos;
    }

    public void readHex() {
        if (this.pos < this.s.length() && (this.s.charAt(this.pos) >= '0' && this.s.charAt(this.pos) <= '9' || this.s.charAt(this.pos) >= 'A' && this.s.charAt(this.pos) <= 'F' || this.s.charAt(this.pos) >= 'a' && this.s.charAt(this.pos) <= 'f')) {
            ++this.pos;
        } else {
            throw new JSONParseException(this.s, this.pos);
        }
    }

    public boolean check(char ch) {
        return this.get() == ch;
    }

    public void skipWS() {
        while (this.pos < this.s.length() && Character.isWhitespace(this.s.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public char get() {
        this.skipWS();
        if (this.pos < this.s.length()) {
            return this.s.charAt(this.pos);
        }
        return '\uffff';
    }

    public String parseString() {
        char current;
        char quot;
        if (this.check('\'')) {
            quot = '\'';
        } else if (this.check('\"')) {
            quot = '\"';
        } else {
            throw new JSONParseException(this.s, this.pos);
        }
        this.read(quot);
        StringBuffer buf = new StringBuffer();
        int start = this.pos;
        block7: while (this.pos < this.s.length() && (current = this.s.charAt(this.pos)) != quot) {
            if (current == '\\') {
                ++this.pos;
                char x = this.get();
                char special = '\u0000';
                switch (x) {
                    case 'u': {
                        buf.append(this.s.substring(start, this.pos - 1));
                        int tempPos = ++this.pos;
                        this.readHex();
                        this.readHex();
                        this.readHex();
                        this.readHex();
                        int codePoint = Integer.parseInt(this.s.substring(tempPos, tempPos + 4), 16);
                        buf.append((char)codePoint);
                        start = this.pos;
                        continue block7;
                    }
                    case 'n': {
                        special = '\n';
                        break;
                    }
                    case 'r': {
                        special = '\r';
                        break;
                    }
                    case 't': {
                        special = '\t';
                        break;
                    }
                    case 'b': {
                        special = '\b';
                    }
                }
                if (special != '\u0000') {
                    buf.append(this.s.substring(start, this.pos - 1));
                    buf.append(special);
                    start = ++this.pos;
                    continue;
                }
            }
            ++this.pos;
        }
        this.read(quot);
        buf.append(this.s.substring(start, this.pos - 1));
        return buf.toString();
    }

    public Number parseNumber() {
        char current = this.get();
        int start = this.pos;
        boolean isDouble = false;
        if (this.check('-') || this.check('+')) {
            ++this.pos;
        }
        block4: while (this.pos < this.s.length()) {
            switch (this.s.charAt(this.pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++this.pos;
                    continue block4;
                }
                case '.': {
                    isDouble = true;
                    this.parseFraction();
                    continue block4;
                }
            }
        }
        if (isDouble) {
            return Double.parseDouble(this.s.substring(start, this.pos));
        }
        if (this.pos - start > 10) {
            return Long.parseLong(this.s.substring(start, this.pos));
        }
        return Integer.parseInt(this.s.substring(start, this.pos));
    }

    public void parseFraction() {
        ++this.pos;
        block3: while (this.pos < this.s.length()) {
            switch (this.s.charAt(this.pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++this.pos;
                    continue block3;
                }
            }
            break;
        }
    }

    public List parseArray() {
        this.read('[');
        ArrayList<Object> list = new ArrayList<Object>();
        char current = this.get();
        while (current != ']') {
            list.add(this.parse());
            current = this.get();
            if (current == ',') {
                this.read(',');
                continue;
            }
            if (current == ']') break;
            throw new JSONParseException(this.s, this.pos);
        }
        this.read(']');
        return list;
    }
}

