/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.ObjectId;

class GridFSChunk {
    protected ObjectId _id;
    protected ObjectId _files_id;
    protected int _n;
    protected byte[] _data;
    protected int _size;

    GridFSChunk(ObjectId fileId, byte[] data, int len, int n) {
        this._id = new ObjectId();
        this._files_id = fileId;
        this._n = n;
        this._data = new byte[len];
        System.arraycopy(data, 0, this._data, 0, len);
        this._size = len;
    }

    GridFSChunk(DBObject o) {
        this._id = (ObjectId)o.get("_id");
        this._files_id = (ObjectId)o.get("files_id");
        this._n = (Integer)o.get("n");
        this._data = (byte[])o.get("data");
        this._size = this._data.length;
    }

    protected long getSize() {
        return this._size;
    }

    protected DBObject getDBObject() {
        BasicDBObject o = new BasicDBObject();
        o.put("_id", (Object)this._id);
        o.put("files_id", (Object)this._files_id);
        o.put("n", (Object)this._n);
        o.put("data", (Object)this._data);
        return o;
    }
}

