/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRegex;
import com.mongodb.DBSymbol;
import com.mongodb.DBUndefined;
import com.mongodb.ObjectId;
import com.mongodb.util.IdentitySet;
import com.mongodb.util.MyAsserts;
import com.mongodb.util.SimplePool;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class ByteEncoder
extends Bytes {
    static final boolean DEBUG = Boolean.getBoolean("DEBUG.BE");
    static final Set<String> BAD_GLOBALS = new HashSet<String>();
    static final SimplePool<ByteEncoder> _pool;
    private final CharBuffer _cbuf = CharBuffer.allocate(524288);
    private final CharsetEncoder _encoder = _utf8.newEncoder();
    private Stack<IdentitySet> _dontRef = new Stack();
    private boolean _flipped = false;
    final ByteBuffer _buf = ByteBuffer.allocateDirect(0x500000);

    public static boolean dbOnlyField(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return ByteEncoder.dbOnlyField(o.toString());
        }
        return false;
    }

    public static boolean dbOnlyField(String s) {
        return s.equals("_ns") || s.equals("_save") || s.equals("_update");
    }

    public static ByteEncoder get() {
        return _pool.get();
    }

    protected void done() {
        this.reset();
        _pool.done(this);
    }

    private ByteEncoder() {
        this._buf.order(Bytes.ORDER);
    }

    public byte[] getBytes() {
        int pos = this._buf.position();
        int limit = this._buf.limit();
        this.flip();
        byte[] arr = new byte[this._buf.limit()];
        this._buf.get(arr);
        this.flip();
        this._buf.position(pos);
        this._buf.limit(limit);
        return arr;
    }

    protected void reset() {
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._flipped = false;
        this._dontRef.clear();
    }

    protected void flip() {
        this._buf.flip();
        this._flipped = true;
    }

    public int putObject(DBObject o) {
        try {
            return this.putObject(null, o);
        }
        catch (BufferOverflowException bof) {
            this.reset();
            throw new IllegalArgumentException("tried to save too large of an object.  max size : " + this._buf.capacity() / 2);
        }
    }

    private int putObject(String name, DBObject o) {
        if (o == null) {
            throw new NullPointerException("can't save a null object");
        }
        if (DEBUG) {
            System.out.println("putObject : " + name + " [" + o.getClass() + "]" + " # keys " + o.keySet().size());
        }
        if (this._flipped) {
            throw new IllegalStateException("already flipped");
        }
        int start = this._buf.position();
        byte myType = 3;
        if (o instanceof List) {
            myType = 4;
        }
        if (this._handleSpecialObjects(name, o)) {
            return this._buf.position() - start;
        }
        if (name != null) {
            this._put(myType, name);
        }
        int sizePos = this._buf.position();
        this._buf.putInt(0);
        List transientFields = null;
        if (myType == 3) {
            Object temp;
            if (o.containsField("_id")) {
                this._putObjectField("_id", o.get("_id"));
            }
            if ((temp = o.get("_transientFields")) instanceof List) {
                transientFields = (List)temp;
            }
        }
        for (String s : o.keySet()) {
            if (s.equals("_id") || transientFields != null && transientFields.contains(s)) continue;
            Object val = o.get(s);
            this._putObjectField(s, val);
        }
        this._buf.put((byte)0);
        this._buf.putInt(sizePos, this._buf.position() - sizePos);
        return this._buf.position() - start;
    }

    private void _putObjectField(String name, Object val) {
        if (ByteEncoder.dbOnlyField(name) || name.equals("_transientFields")) {
            return;
        }
        if (DEBUG) {
            System.out.println("\t put thing : " + name);
        }
        if (name.equals("$where") && val instanceof String) {
            this._put((byte)13, name);
            this._putValueString(val.toString());
            return;
        }
        if (val == null) {
            this.putNull(name);
        } else if (val instanceof Date) {
            this.putDate(name, (Date)val);
        } else if (val instanceof Number) {
            this.putNumber(name, (Number)val);
        } else if (val instanceof String) {
            this.putString(name, val.toString());
        } else if (val instanceof ObjectId) {
            this.putObjectId(name, (ObjectId)val);
        } else if (val instanceof DBObject) {
            this.putObject(name, (DBObject)val);
        } else if (val instanceof Boolean) {
            this.putBoolean(name, (Boolean)val);
        } else if (val instanceof Pattern) {
            this.putPattern(name, (Pattern)val);
        } else if (val instanceof DBRegex) {
            this.putDBRegex(name, (DBRegex)val);
        } else if (val instanceof Map) {
            this.putMap(name, (Map)val);
        } else if (val instanceof List) {
            this.putList(name, (List)val);
        } else if (val instanceof byte[]) {
            this.putBinary(name, (byte[])val);
        } else if (val.getClass().isArray()) {
            this.putList(name, Arrays.asList((Object[])val));
        } else if (val instanceof DBPointer) {
            DBPointer r = (DBPointer)val;
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
        } else if (val instanceof DBSymbol) {
            this.putSymbol(name, (DBSymbol)val);
        } else if (val instanceof DBUndefined) {
            this.putUndefined(name);
        } else {
            throw new IllegalArgumentException("can't serialize " + val.getClass());
        }
    }

    private void putList(String name, List l) {
        this._put((byte)4, name);
        int sizePos = this._buf.position();
        this._buf.putInt(0);
        for (int i = 0; i < l.size(); ++i) {
            this._putObjectField(String.valueOf(i), l.get(i));
        }
        this._buf.put((byte)0);
        this._buf.putInt(sizePos, this._buf.position() - sizePos);
    }

    private void putMap(String name, Map m) {
        this._put((byte)3, name);
        int sizePos = this._buf.position();
        this._buf.putInt(0);
        for (Object key : m.keySet()) {
            this._putObjectField(key.toString(), m.get(key));
        }
        this._buf.put((byte)0);
        this._buf.putInt(sizePos, this._buf.position() - sizePos);
    }

    private boolean _handleSpecialObjects(String name, DBObject o) {
        if (o == null) {
            return false;
        }
        if (o instanceof DBCollection) {
            DBCollection c = (DBCollection)((Object)o);
            this.putDBPointer(name, c.getName(), Bytes.COLLECTION_REF_ID);
            return true;
        }
        if (!this._dontRefContains(o) && name != null && o instanceof DBPointer) {
            DBPointer r = (DBPointer)((Object)o);
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
            return true;
        }
        if (!(o instanceof List) && o.get("_____nodbref_____") != null) {
            o.removeField("_____nodbref_____");
            return false;
        }
        if (!this._dontRefContains(o) && name != null && !(o instanceof List) && ByteEncoder.cameFromDB(o)) {
            this.putDBPointer(name, o.get("_ns").toString(), (ObjectId)o.get("_id"));
            return true;
        }
        return false;
    }

    protected int putNull(String name) {
        int start = this._buf.position();
        this._put((byte)10, name);
        return this._buf.position() - start;
    }

    protected int putUndefined(String name) {
        int start = this._buf.position();
        this._put((byte)6, name);
        return this._buf.position() - start;
    }

    protected int putBoolean(String name, Boolean b) {
        int start = this._buf.position();
        this._put((byte)8, name);
        this._buf.put(b != false ? (byte)1 : 0);
        return this._buf.position() - start;
    }

    protected int putDate(String name, Date d) {
        int start = this._buf.position();
        this._put((byte)9, name);
        this._buf.putLong(d.getTime());
        return this._buf.position() - start;
    }

    protected int putNumber(String name, Number n) {
        int start = this._buf.position();
        if (n instanceof Integer) {
            this._put((byte)16, name);
            this._buf.putInt(n.intValue());
        } else if (n instanceof Long) {
            this._put((byte)18, name);
            this._buf.putLong(n.longValue());
        } else {
            this._put((byte)1, name);
            this._buf.putDouble(n.doubleValue());
        }
        return this._buf.position() - start;
    }

    protected void putBinary(String name, byte[] data) {
        this._put((byte)5, name);
        this._buf.putInt(4 + data.length);
        this._buf.put((byte)2);
        this._buf.putInt(data.length);
        int before = this._buf.position();
        this._buf.put(data);
        int after = this._buf.position();
        MyAsserts.assertEquals(after - before, data.length);
    }

    protected int putSymbol(String name, DBSymbol s) {
        return this._putString(name, s.getSymbol(), (byte)14);
    }

    protected int putString(String name, String s) {
        return this._putString(name, s, (byte)2);
    }

    private int _putString(String name, String s, byte type) {
        int start = this._buf.position();
        this._put(type, name);
        this._putValueString(s);
        return this._buf.position() - start;
    }

    protected int putObjectId(String name, ObjectId oid) {
        int start = this._buf.position();
        this._put((byte)7, name);
        this._buf.putLong(oid._base);
        this._buf.putInt(oid._inc);
        return this._buf.position() - start;
    }

    protected int putDBPointer(String name, String ns, ObjectId oid) {
        int start = this._buf.position();
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.putLong(oid._base);
        this._buf.putInt(oid._inc);
        return this._buf.position() - start;
    }

    private int putDBRegex(String name, DBRegex regex) {
        int start = this._buf.position();
        this._put((byte)11, name);
        this._put(regex.getPattern());
        String options = regex.getOptions();
        TreeMap<Character, Character> sm = new TreeMap<Character, Character>();
        for (int i = 0; i < options.length(); ++i) {
            sm.put(Character.valueOf(options.charAt(i)), Character.valueOf(options.charAt(i)));
        }
        StringBuffer sb = new StringBuffer();
        Iterator i$ = sm.keySet().iterator();
        while (i$.hasNext()) {
            char c = ((Character)i$.next()).charValue();
            sb.append(c);
        }
        this._put(sb.toString());
        return this._buf.position() - start;
    }

    private int putPattern(String name, Pattern p) {
        int start = this._buf.position();
        this._put((byte)11, name);
        this._put(p.pattern());
        this._put(ByteEncoder.patternFlags(p.flags()));
        return this._buf.position() - start;
    }

    private void _put(byte type, String name) {
        this._buf.put(type);
        this._put(name);
    }

    void _putValueString(String s) {
        int lenPos = this._buf.position();
        this._buf.putInt(0);
        int strLen = this._put(s);
        this._buf.putInt(lenPos, strLen);
    }

    int _put(String name) {
        this._cbuf.position(0);
        this._cbuf.limit(this._cbuf.capacity());
        this._cbuf.append(name);
        this._cbuf.flip();
        int start = this._buf.position();
        this._encoder.encode(this._cbuf, this._buf, false);
        this._buf.put((byte)0);
        return this._buf.position() - start;
    }

    boolean _dontRefContains(Object o) {
        if (this._dontRef.size() == 0) {
            return false;
        }
        return this._dontRef.peek().contains(o);
    }

    static {
        BAD_GLOBALS.add("db");
        BAD_GLOBALS.add("local");
        BAD_GLOBALS.add("core");
        BAD_GLOBALS.add("args");
        BAD_GLOBALS.add("obj");
        _pool = new SimplePool<ByteEncoder>("ByteEncoders", NUM_ENCODERS, NUM_ENCODERS * 2){

            @Override
            protected ByteEncoder createNew() {
                if (Bytes.D) {
                    System.out.println("creating new ByteEncoder");
                }
                return new ByteEncoder();
            }

            protected long memSize(ByteEncoder d) {
                return 0x600400L;
            }
        };
    }
}

