/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.util.OrderedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BasicDBList
extends ArrayList<Object>
implements DBObject {
    private boolean _isPartialObject;

    @Override
    public Object put(String key, Object v) {
        return this.put(this._getInt(key), v);
    }

    public Object put(int key, Object v) {
        while (key >= this.size()) {
            this.add(null);
        }
        this.set(key, v);
        return v;
    }

    @Override
    public void putAll(Map m) {
        for (Object k : m.keySet()) {
            this.put(k.toString(), m.get(k));
        }
    }

    @Override
    public void putAll(DBObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    @Override
    public Object get(String key) {
        int i = this._getInt(key);
        if (i < 0) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return this.get(i);
    }

    @Override
    public Object removeField(String key) {
        int i = this._getInt(key);
        if (i < 0) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return this.remove(i);
    }

    @Override
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public boolean containsField(String key) {
        int i = this._getInt(key);
        return i >= 0 && i < this.size();
    }

    @Override
    public Set<String> keySet() {
        OrderedSet<String> s = new OrderedSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            s.add(String.valueOf(i));
        }
        return s;
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String s : this.keySet()) {
            m.put(s, this.get(s + ""));
        }
        return m;
    }

    int _getInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("BasicDBList can only work with numeric keys, not: [" + s + "]");
        }
    }

    @Override
    public boolean isPartialObject() {
        return this._isPartialObject;
    }

    @Override
    public void markAsPartialObject() {
        this._isPartialObject = true;
    }
}

