/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

public class CircularList<T> {
    final T[] _array;
    final boolean _stack;
    private int _pos;
    private int _size;

    public CircularList(int capacity, boolean stack) {
        this._array = new Object[capacity];
        this._pos = 0;
        this._size = 0;
        this._stack = stack;
    }

    public void clear() {
        this._size = 0;
        this._pos = 0;
        for (int i = 0; i < this._array.length; ++i) {
            this._array[i] = null;
        }
    }

    public void add(T t) {
        this._array[this._pos++] = t;
        if (this._pos == this._array.length) {
            this._pos = 0;
        }
        if (this._size < this._array.length) {
            ++this._size;
        }
    }

    public T get(int i) {
        int pos;
        int n = pos = this._stack ? this._pos - (1 + i) : this._pos - this._size + i;
        if (pos < 0) {
            pos += this._array.length;
        }
        return this._array[pos];
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._array.length;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        boolean first = true;
        for (int i = 0; i < this.size(); ++i) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(this.get(i));
        }
        buf.append("]");
        return buf.toString();
    }
}

