/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlinx;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.bson.BsonWriter;
import org.bson.codecs.kotlinx.BsonConfiguration;
import org.bson.codecs.kotlinx.BsonEncoderImpl;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J)\u0010\u001d\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 2\u0006\u0010!\u001a\u0002H\u001eH\u0016\u00a2\u0006\u0002\u0010\"R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/bson/codecs/kotlinx/JsonBsonEncoder;", "Lorg/bson/codecs/kotlinx/BsonEncoderImpl;", "Lkotlinx/serialization/json/JsonEncoder;", "writer", "Lorg/bson/BsonWriter;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lorg/bson/codecs/kotlinx/BsonConfiguration;", "(Lorg/bson/BsonWriter;Lkotlinx/serialization/modules/SerializersModule;Lorg/bson/codecs/kotlinx/BsonConfiguration;)V", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "encodeJsonArray", "", "array", "Lkotlinx/serialization/json/JsonArray;", "encodeJsonElement", "element", "Lkotlinx/serialization/json/JsonElement;", "encodeJsonObject", "obj", "Lkotlinx/serialization/json/JsonObject;", "encodeJsonPrimitive", "primitive", "Lkotlinx/serialization/json/JsonPrimitive;", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "Companion", "bson-kotlinx"})
@SourceDebugExtension(value={"SMAP\nJsonBsonEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonBsonEncoder.kt\norg/bson/codecs/kotlinx/JsonBsonEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1855#2,2:134\n*S KotlinDebug\n*F\n+ 1 JsonBsonEncoder.kt\norg/bson/codecs/kotlinx/JsonBsonEncoder\n*L\n129#1:134,2\n*E\n"})
public final class JsonBsonEncoder
extends BsonEncoderImpl
implements JsonEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Json json;
    private static final BigDecimal DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    private static final BigDecimal DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal INT_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal INT_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);

    public JsonBsonEncoder(@NotNull BsonWriter writer, @NotNull SerializersModule serializersModule, @NotNull BsonConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(writer, serializersModule, configuration);
        this.serializersModule = serializersModule;
        this.json = JsonKt.Json$default(null, (Function1)((Function1)new Function1<JsonBuilder, Unit>(configuration, this){
            final /* synthetic */ BsonConfiguration $configuration;
            final /* synthetic */ JsonBsonEncoder this$0;
            {
                this.$configuration = $configuration;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonBuilder $this$Json) {
                Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
                $this$Json.setExplicitNulls(this.$configuration.getExplicitNulls());
                $this$Json.setEncodeDefaults(this.$configuration.getEncodeDefaults());
                $this$Json.setClassDiscriminator(this.$configuration.getClassDiscriminator());
                $this$Json.setSerializersModule(this.this$0.getSerializersModule());
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public Json getJson() {
        return this.json;
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (value instanceof JsonElement) {
            this.encodeJsonElement((JsonElement)value);
        } else {
            super.encodeSerializableValue(serializer, value);
        }
    }

    public void encodeJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.getDeferredElementHandler$bson_kotlinx().with((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(element, this){
            final /* synthetic */ JsonElement $element;
            final /* synthetic */ JsonBsonEncoder this$0;
            {
                this.$element = $element;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsonElement jsonElement = this.$element;
                if (jsonElement instanceof JsonNull) {
                    if (this.this$0.getConfiguration().getExplicitNulls()) {
                        this.this$0.encodeName$bson_kotlinx(it);
                        this.this$0.encodeNull();
                    }
                } else if (jsonElement instanceof JsonPrimitive) {
                    this.this$0.encodeName$bson_kotlinx(it);
                    JsonBsonEncoder.access$encodeJsonPrimitive(this.this$0, (JsonPrimitive)this.$element);
                } else if (jsonElement instanceof JsonObject) {
                    this.this$0.encodeName$bson_kotlinx(it);
                    JsonBsonEncoder.access$encodeJsonObject(this.this$0, (JsonObject)this.$element);
                } else if (jsonElement instanceof JsonArray) {
                    this.this$0.encodeName$bson_kotlinx(it);
                    JsonBsonEncoder.access$encodeJsonArray(this.this$0, (JsonArray)this.$element);
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(element, this){
            final /* synthetic */ JsonElement $element;
            final /* synthetic */ JsonBsonEncoder this$0;
            {
                this.$element = $element;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                JsonElement jsonElement = this.$element;
                if (jsonElement instanceof JsonNull) {
                    if (this.this$0.getConfiguration().getExplicitNulls()) {
                        this.this$0.encodeNull();
                    }
                } else if (jsonElement instanceof JsonPrimitive) {
                    JsonBsonEncoder.access$encodeJsonPrimitive(this.this$0, (JsonPrimitive)this.$element);
                } else if (jsonElement instanceof JsonObject) {
                    JsonBsonEncoder.access$encodeJsonObject(this.this$0, (JsonObject)this.$element);
                } else if (jsonElement instanceof JsonArray) {
                    JsonBsonEncoder.access$encodeJsonArray(this.this$0, (JsonArray)this.$element);
                }
            }
        }));
    }

    private final void encodeJsonPrimitive(JsonPrimitive primitive) {
        String content = primitive.getContent();
        if (primitive.isString()) {
            this.encodeString(content);
        } else if (Intrinsics.areEqual((Object)content, (Object)"true") || Intrinsics.areEqual((Object)content, (Object)"false")) {
            this.encodeBoolean(StringsKt.toBooleanStrict((String)content));
        } else {
            BigDecimal decimal = new BigDecimal(content);
            if (decimal.scale() != 0) {
                if (DOUBLE_MIN_VALUE.compareTo(decimal) <= 0 && decimal.compareTo(DOUBLE_MAX_VALUE) <= 0) {
                    this.encodeDouble(JsonElementKt.getDouble((JsonPrimitive)primitive));
                } else {
                    this.getWriter().writeDecimal128(new Decimal128(decimal));
                }
            } else if (INT_MIN_VALUE.compareTo(decimal) <= 0 && decimal.compareTo(INT_MAX_VALUE) <= 0) {
                this.encodeInt(JsonElementKt.getInt((JsonPrimitive)primitive));
            } else if (LONG_MIN_VALUE.compareTo(decimal) <= 0 && decimal.compareTo(LONG_MAX_VALUE) <= 0) {
                this.encodeLong(JsonElementKt.getLong((JsonPrimitive)primitive));
            } else {
                this.getWriter().writeDecimal128(new Decimal128(decimal));
            }
        }
    }

    private final void encodeJsonObject(JsonObject obj) {
        this.getWriter().writeStartDocument();
        obj.forEach((arg_0, arg_1) -> JsonBsonEncoder.encodeJsonObject$lambda$0((Function2)new Function2<String, JsonElement, Unit>(this){
            final /* synthetic */ JsonBsonEncoder this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String k, @NotNull JsonElement v) {
                Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                this.this$0.getDeferredElementHandler$bson_kotlinx().set(k);
                this.this$0.encodeJsonElement(v);
            }
        }, arg_0, arg_1));
        this.getWriter().writeEndDocument();
    }

    private final void encodeJsonArray(JsonArray array) {
        this.getWriter().writeStartArray();
        Iterable $this$forEach$iv = (Iterable)array;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonElement p0 = (JsonElement)element$iv;
            boolean bl = false;
            this.encodeJsonElement(p0);
        }
        this.getWriter().writeEndArray();
    }

    private static final void encodeJsonObject$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$encodeJsonPrimitive(JsonBsonEncoder $this, JsonPrimitive primitive) {
        $this.encodeJsonPrimitive(primitive);
    }

    public static final /* synthetic */ void access$encodeJsonObject(JsonBsonEncoder $this, JsonObject obj) {
        $this.encodeJsonObject(obj);
    }

    public static final /* synthetic */ void access$encodeJsonArray(JsonBsonEncoder $this, JsonArray array) {
        $this.encodeJsonArray(array);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/bson/codecs/kotlinx/JsonBsonEncoder$Companion;", "", "()V", "DOUBLE_MAX_VALUE", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "DOUBLE_MIN_VALUE", "INT_MAX_VALUE", "INT_MIN_VALUE", "LONG_MAX_VALUE", "LONG_MIN_VALUE", "bson-kotlinx"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

