/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlinx;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.kotlinx.BsonConfiguration;
import org.bson.codecs.kotlinx.BsonEncoder;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0010\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0004EFGHB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020+H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u0010 \u001a\u000202H\u0016J\u0015\u00103\u001a\u00020\u001f2\u0006\u0010 \u001a\u000204H\u0000\u00a2\u0006\u0002\b5J\b\u00106\u001a\u00020\u001fH\u0016J/\u00107\u001a\u00020\u001f\"\b\b\u0000\u00108*\u0002042\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:2\b\u0010 \u001a\u0004\u0018\u0001H8H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020=H\u0016J)\u0010>\u001a\u00020\u001f\"\u0004\b\u0000\u001082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:2\u0006\u0010 \u001a\u0002H8H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010?\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010D\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006I"}, d2={"Lorg/bson/codecs/kotlinx/BsonEncoderImpl;", "Lorg/bson/codecs/kotlinx/BsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "writer", "Lorg/bson/BsonWriter;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lorg/bson/codecs/kotlinx/BsonConfiguration;", "(Lorg/bson/BsonWriter;Lkotlinx/serialization/modules/SerializersModule;Lorg/bson/codecs/kotlinx/BsonConfiguration;)V", "getConfiguration", "()Lorg/bson/codecs/kotlinx/BsonConfiguration;", "deferredElementHandler", "Lorg/bson/codecs/kotlinx/BsonEncoderImpl$DeferredElementHandler;", "getDeferredElementHandler$bson_kotlinx", "()Lorg/bson/codecs/kotlinx/BsonEncoderImpl$DeferredElementHandler;", "isPolymorphic", "", "mapState", "Lorg/bson/codecs/kotlinx/BsonEncoderImpl$MapState;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "state", "Lorg/bson/codecs/kotlinx/BsonEncoderImpl$STATE;", "getWriter", "()Lorg/bson/BsonWriter;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "", "value", "encodeBsonValue", "Lorg/bson/BsonValue;", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescriptor", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeName", "", "encodeName$bson_kotlinx", "encodeNull", "encodeNullableSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeObjectId", "Lorg/bson/types/ObjectId;", "encodeSerializableValue", "encodeShort", "", "encodeString", "", "endStructure", "shouldEncodeElementDefault", "Companion", "DeferredElementHandler", "MapState", "STATE", "bson-kotlinx"})
public class BsonEncoderImpl
extends AbstractEncoder
implements BsonEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BsonWriter writer;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final BsonConfiguration configuration;
    private boolean isPolymorphic;
    @NotNull
    private STATE state;
    @NotNull
    private MapState mapState;
    @NotNull
    private final DeferredElementHandler deferredElementHandler;
    @NotNull
    private static final Set<SerialKind> validKeyKinds;
    @NotNull
    private static final BsonValueCodec bsonValueCodec;

    public BsonEncoderImpl(@NotNull BsonWriter writer, @NotNull SerializersModule serializersModule, @NotNull BsonConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.writer = writer;
        this.serializersModule = serializersModule;
        this.configuration = configuration;
        this.state = STATE.VALUE;
        this.mapState = new MapState();
        this.deferredElementHandler = new DeferredElementHandler();
    }

    @NotNull
    public final BsonWriter getWriter() {
        return this.writer;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final BsonConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final DeferredElementHandler getDeferredElementHandler$bson_kotlinx() {
        return this.deferredElementHandler;
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.configuration.getEncodeDefaults();
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof PolymorphicKind) {
            this.writer.writeStartDocument();
            this.writer.writeName(this.configuration.getClassDiscriminator());
            this.isPolymorphic = true;
        } else if (serialKind instanceof StructureKind.LIST) {
            this.writer.writeStartArray();
        } else if (serialKind instanceof StructureKind.CLASS ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            if (this.isPolymorphic) {
                this.isPolymorphic = false;
            } else {
                this.writer.writeStartDocument();
            }
        } else if (serialKind instanceof StructureKind.MAP) {
            this.writer.writeStartDocument();
            this.mapState = new MapState();
        } else {
            throw new SerializationException("Primitives are not supported at top-level");
        }
        return this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof StructureKind.LIST) {
            this.writer.writeEndArray();
        } else if ((Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            this.writer.writeEndDocument();
        }
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof StructureKind.CLASS) {
            String elementName = descriptor.getElementName(index);
            if (descriptor.getElementDescriptor(index).isNullable()) {
                this.deferredElementHandler.set(elementName);
            } else {
                this.encodeName$bson_kotlinx(elementName);
            }
        } else if (serialKind instanceof StructureKind.MAP) {
            SerialKind keyKind;
            if (index == 0 && !validKeyKinds.contains(keyKind = descriptor.getElementDescriptor(index).getKind())) {
                throw new SerializationException(StringsKt.trimMargin$default((String)("Invalid key type for " + descriptor.getSerialName() + ".\n                                | Expected STRING or ENUM but found: `" + keyKind + "`."), null, (int)1, null));
            }
            this.state = this.mapState.nextState();
        }
        return true;
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.deferredElementHandler.with((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(value, this, serializer){
            final /* synthetic */ T $value;
            final /* synthetic */ BsonEncoderImpl this$0;
            final /* synthetic */ SerializationStrategy<T> $serializer;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                this.$serializer = $serializer;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$value != null || this.this$0.getConfiguration().getExplicitNulls()) {
                    this.this$0.encodeName$bson_kotlinx(it);
                    BsonEncoderImpl.access$encodeSerializableValue$s848091770(this.this$0, this.$serializer, this.$value);
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this, serializer, value){
            final /* synthetic */ BsonEncoderImpl this$0;
            final /* synthetic */ SerializationStrategy<T> $serializer;
            final /* synthetic */ T $value;
            {
                this.this$0 = $receiver;
                this.$serializer = $serializer;
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                BsonEncoderImpl.access$encodeSerializableValue$s848091770(this.this$0, this.$serializer, this.$value);
            }
        }));
    }

    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.deferredElementHandler.with((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(value, this, serializer){
            final /* synthetic */ T $value;
            final /* synthetic */ BsonEncoderImpl this$0;
            final /* synthetic */ SerializationStrategy<T> $serializer;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                this.$serializer = $serializer;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$value != null || this.this$0.getConfiguration().getExplicitNulls()) {
                    this.this$0.encodeName$bson_kotlinx(it);
                    BsonEncoderImpl.access$encodeNullableSerializableValue$s848091770(this.this$0, this.$serializer, this.$value);
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this, serializer, value){
            final /* synthetic */ BsonEncoderImpl this$0;
            final /* synthetic */ SerializationStrategy<T> $serializer;
            final /* synthetic */ T $value;
            {
                this.this$0 = $receiver;
                this.$serializer = $serializer;
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                BsonEncoderImpl.access$encodeNullableSerializableValue$s848091770(this.this$0, this.$serializer, this.$value);
            }
        }));
    }

    public void encodeByte(byte value) {
        this.encodeInt(value);
    }

    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    public void encodeFloat(float value) {
        this.encodeDouble(value);
    }

    public void encodeShort(short value) {
        this.encodeInt(value);
    }

    public void encodeBoolean(boolean value) {
        this.writer.writeBoolean(value);
    }

    public void encodeDouble(double value) {
        this.writer.writeDouble(value);
    }

    public void encodeInt(int value) {
        this.writer.writeInt32(value);
    }

    public void encodeLong(long value) {
        this.writer.writeInt64(value);
    }

    public void encodeNull() {
        this.writer.writeNull();
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.deferredElementHandler.set(value);
                break;
            }
            case 2: {
                this.writer.writeString(value);
            }
        }
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String value = enumDescriptor.getElementName(index);
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.encodeName$bson_kotlinx(value);
                break;
            }
            case 2: {
                this.writer.writeString(value);
            }
        }
    }

    @Override
    public void encodeObjectId(@NotNull ObjectId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writer.writeObjectId(value);
    }

    @Override
    public void encodeBsonValue(@NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        bsonValueCodec.encode(this.writer, value, EncoderContext.builder().build());
    }

    public final void encodeName$bson_kotlinx(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writer.writeName(value.toString());
        this.state = STATE.VALUE;
    }

    public static final /* synthetic */ void access$encodeSerializableValue$s848091770(BsonEncoderImpl $this, SerializationStrategy serializer, Object value) {
        super.encodeSerializableValue(serializer, value);
    }

    public static final /* synthetic */ void access$encodeNullableSerializableValue$s848091770(BsonEncoderImpl $this, SerializationStrategy serializer, Object value) {
        super.encodeNullableSerializableValue(serializer, value);
    }

    static {
        Object[] objectArray = new SerialKind[]{(SerialKind)PrimitiveKind.STRING.INSTANCE, (SerialKind)PrimitiveKind.CHAR.INSTANCE, (SerialKind)SerialKind.ENUM.INSTANCE};
        validKeyKinds = SetsKt.setOf((Object[])objectArray);
        bsonValueCodec = new BsonValueCodec();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/bson/codecs/kotlinx/BsonEncoderImpl$Companion;", "", "()V", "bsonValueCodec", "Lorg/bson/codecs/BsonValueCodec;", "getBsonValueCodec", "()Lorg/bson/codecs/BsonValueCodec;", "validKeyKinds", "", "Lkotlinx/serialization/descriptors/SerialKind;", "getValidKeyKinds", "()Ljava/util/Set;", "bson-kotlinx"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<SerialKind> getValidKeyKinds() {
            return validKeyKinds;
        }

        @NotNull
        public final BsonValueCodec getBsonValueCodec() {
            return bsonValueCodec;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004J(\u0010\t\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/bson/codecs/kotlinx/BsonEncoderImpl$DeferredElementHandler;", "", "()V", "deferredElementName", "", "reset", "", "set", "name", "with", "actionWithDeferredElement", "Lkotlin/Function1;", "actionWithoutDeferredElement", "Lkotlin/Function0;", "bson-kotlinx"})
    @SourceDebugExtension(value={"SMAP\nBsonEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BsonEncoder.kt\norg/bson/codecs/kotlinx/BsonEncoderImpl$DeferredElementHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
    public static final class DeferredElementHandler {
        @Nullable
        private String deferredElementName;

        public final void set(@NotNull String name) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            boolean bl2 = bl = this.deferredElementName == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Overwriting an existing deferred name";
                throw new AssertionError((Object)string);
            }
            this.deferredElementName = name;
        }

        public final void with(@NotNull Function1<? super String, Unit> actionWithDeferredElement, @NotNull Function0<Unit> actionWithoutDeferredElement) {
            block2: {
                Unit unit;
                Intrinsics.checkNotNullParameter(actionWithDeferredElement, (String)"actionWithDeferredElement");
                Intrinsics.checkNotNullParameter(actionWithoutDeferredElement, (String)"actionWithoutDeferredElement");
                String string = this.deferredElementName;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    this.reset();
                    actionWithDeferredElement.invoke((Object)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block2;
                actionWithoutDeferredElement.invoke();
            }
        }

        private final void reset() {
            this.deferredElementName = null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/bson/codecs/kotlinx/BsonEncoderImpl$MapState;", "", "()V", "currentState", "Lorg/bson/codecs/kotlinx/BsonEncoderImpl$STATE;", "getCurrentState", "()Lorg/bson/codecs/kotlinx/BsonEncoderImpl$STATE;", "setCurrentState", "(Lorg/bson/codecs/kotlinx/BsonEncoderImpl$STATE;)V", "getState", "nextState", "bson-kotlinx"})
    private static final class MapState {
        @NotNull
        private STATE currentState = STATE.VALUE;

        @NotNull
        public final STATE getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(@NotNull STATE sTATE) {
            Intrinsics.checkNotNullParameter((Object)((Object)sTATE), (String)"<set-?>");
            this.currentState = sTATE;
        }

        @NotNull
        public final STATE getState() {
            return this.currentState;
        }

        @NotNull
        public final STATE nextState() {
            STATE sTATE;
            switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
                case 1: {
                    sTATE = STATE.NAME;
                    break;
                }
                case 2: {
                    sTATE = STATE.VALUE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.currentState = sTATE;
            return this.getState();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[STATE.values().length];
                try {
                    nArray[STATE.VALUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[STATE.NAME.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/bson/codecs/kotlinx/BsonEncoderImpl$STATE;", "", "(Ljava/lang/String;I)V", "NAME", "VALUE", "bson-kotlinx"})
    private static final class STATE
    extends Enum<STATE> {
        public static final /* enum */ STATE NAME = new STATE();
        public static final /* enum */ STATE VALUE = new STATE();
        private static final /* synthetic */ STATE[] $VALUES;

        public static STATE[] values() {
            return (STATE[])$VALUES.clone();
        }

        public static STATE valueOf(String value) {
            return Enum.valueOf(STATE.class, value);
        }

        static {
            $VALUES = sTATEArray = new STATE[]{STATE.NAME, STATE.VALUE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[STATE.values().length];
            try {
                nArray[STATE.NAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[STATE.VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

