/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlinx;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import org.bson.AbstractBsonReader;
import org.bson.BsonType;
import org.bson.codecs.kotlinx.BsonConfiguration;
import org.bson.codecs.kotlinx.DefaultBsonDecoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/bson/codecs/kotlinx/MapDecoder;", "Lorg/bson/codecs/kotlinx/DefaultBsonDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "reader", "Lorg/bson/AbstractBsonReader;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lorg/bson/codecs/kotlinx/BsonConfiguration;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lorg/bson/AbstractBsonReader;Lkotlinx/serialization/modules/SerializersModule;Lorg/bson/codecs/kotlinx/BsonConfiguration;)V", "index", "", "isKey", "", "decodeElementIndex", "decodeString", "", "bson-kotlinx"})
final class MapDecoder
extends DefaultBsonDecoder {
    private int index;
    private boolean isKey;

    public MapDecoder(@NotNull SerialDescriptor descriptor, @NotNull AbstractBsonReader reader, @NotNull SerializersModule serializersModule, @NotNull BsonConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(reader, serializersModule, configuration);
        DefaultBsonDecoder.Companion.validateCurrentBsonType$default(DefaultBsonDecoder.Companion, reader, BsonType.DOCUMENT, descriptor, null, 8, null);
        reader.readStartDocument();
    }

    @Override
    @NotNull
    public String decodeString() {
        String string;
        if (this.isKey) {
            String string2 = this.getReader$bson_kotlinx().readName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            reader.readName()\n        }");
        } else {
            string = super.decodeString();
        }
        return string;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind keyKind = descriptor.getElementDescriptor(0).getKind();
        if (!DefaultBsonDecoder.Companion.getValidKeyKinds().contains(keyKind)) {
            throw new SerializationException("Invalid key type for " + descriptor.getSerialName() + ". Expected STRING or ENUM but found: `" + keyKind + '`');
        }
        if (!this.isKey) {
            this.isKey = true;
            BsonType nextType = this.getReader$bson_kotlinx().readBsonType();
            if (nextType == BsonType.END_OF_DOCUMENT) {
                return -1;
            }
        } else {
            this.isKey = false;
        }
        int n = this.index;
        this.index = n + 1;
        return n;
    }
}

