/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import java.util.Arrays;
import java.util.List;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.modelmapper.spi.MappingContext;
import org.testng.Assert;

public class FieldRelocation {
    public static void main(String ... args) {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.addConverter((Converter)new Converter<Car, AnotherCar>(){

            public AnotherCar convert(MappingContext<Car, AnotherCar> context) {
                Person person = (Person)context.getParent().getParent().getSource();
                ((AnotherCar)context.getDestination()).setPersonName(person.getName());
                ((AnotherCar)context.getDestination()).setType(((Car)context.getSource()).getType());
                return (AnotherCar)context.getDestination();
            }
        });
        modelMapper.addMappings((PropertyMap)new PropertyMap<Person, AnotherPerson>(){

            protected void configure() {
                ((AnotherPerson)this.map(((Person)this.source).getCars())).setAnotherCars(null);
            }
        });
        Person person = new Person();
        person.name = "joe";
        Car car1 = new Car();
        car1.type = "Honda";
        Car car2 = new Car();
        car2.type = "Toyota";
        person.cars = Arrays.asList(car1, car2);
        AnotherPerson anotherPerson = (AnotherPerson)modelMapper.map((Object)person, AnotherPerson.class);
        Assert.assertEquals((String)anotherPerson.getCars().get((int)0).personName, (String)"joe");
        Assert.assertEquals((String)anotherPerson.getCars().get((int)0).type, (String)car1.type);
        Assert.assertEquals((String)anotherPerson.getCars().get((int)1).personName, (String)"joe");
        Assert.assertEquals((String)anotherPerson.getCars().get((int)1).type, (String)car2.type);
    }

    public static class AnotherCar {
        String personName;
        String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPersonName() {
            return this.personName;
        }

        public void setPersonName(String personName) {
            this.personName = personName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnotherPerson {
        List<AnotherCar> cars;

        public List<AnotherCar> getCars() {
            return this.cars;
        }

        public void setAnotherCars(List<AnotherCar> cars) {
            this.cars = cars;
        }
    }

    public static class Car {
        String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Person {
        String name;
        List<Car> cars;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Car> getCars() {
            return this.cars;
        }

        public void setCars(List<Car> cars) {
            this.cars = cars;
        }
    }
}

