/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collection;
import org.modelmapper.internal.util.MappingContextHelper;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class ArrayNodeToCollectionConverter
implements ConditionalConverter<ArrayNode, Collection<Object>> {
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Collection.class.isAssignableFrom(destinationType) && sourceType.isAssignableFrom(ArrayNode.class) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    public Collection<Object> convert(MappingContext<ArrayNode, Collection<Object>> context) {
        ArrayNode source = (ArrayNode)context.getSource();
        if (source == null) {
            return null;
        }
        int sourceLength = source.size();
        Collection<Object> destination = context.getDestination() == null ? this.createDestination(context, sourceLength) : (Collection<Object>)context.getDestination();
        Class elementType = MappingContextHelper.resolveDestinationGenericType(context);
        for (Object sourceElement : source) {
            Object element = null;
            if (sourceElement != null) {
                MappingContext elementContext = context.create(sourceElement, elementType);
                element = context.getMappingEngine().map(elementContext);
            }
            destination.add(element);
        }
        return destination;
    }

    private Collection<Object> createDestination(MappingContext<ArrayNode, Collection<Object>> context, int length) {
        return MappingContextHelper.createCollection(context, (int)length);
    }
}

