/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.AbstractClient;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;

public class ProxyClient
extends AbstractClient
implements Closeable {
    public ProxyClient(String host, int port) {
        this(host, port, "");
    }

    public ProxyClient(String host, int port, String contextPath) {
        super(host, port, contextPath);
    }

    public ProxyClient dumpToLogAsJSON() {
        return this.dumpToLogAsJSON(null);
    }

    public ProxyClient dumpToLogAsJSON(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("dumpToLog")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this;
    }

    public ProxyClient dumpToLogAsJava() {
        return this.dumpToLogAsJava(null);
    }

    public ProxyClient dumpToLogAsJava(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("dumpToLog?type=java")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this;
    }

    public boolean isRunning() {
        return this.isRunning(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")));
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return this.isRunning(attempts - 1, timeout, timeUnit);
        }
        catch (SocketConnectionException sce) {
            return false;
        }
    }

    public ProxyClient stop() {
        return this.stop(false);
    }

    public ProxyClient stop(boolean ignoreFailure) {
        block4: {
            try {
                this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
                if (this.isRunning()) {
                    for (int i = 0; this.isRunning() && i < 50; ++i) {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                }
            }
            catch (Exception e) {
                if (ignoreFailure) break block4;
                this.logger.warn("Failed to send stop request to proxy " + e.getMessage());
            }
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public ProxyClient reset() {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this;
    }

    public ProxyClient clear(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this;
    }

    public ProxyClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0 || httpRequests[0] == null) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence))).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public ProxyClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withRequest(httpRequest).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification))).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString());
    }

    public String retrieveAsJSON(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return httpResponse.getBodyAsString();
    }
}

